package com.tydic.dyc.oc.model.aforder.qrybo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfOrderQryBo
 * 说明:售后服务信息表
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfOrderQryBo implements Serializable {
	private static final long serialVersionUID = -5802524658841348084L;

	//售后服务单id")
	private Long afOrderId;

	//售后服务单id集合")
	private List<Long> afOrderIds;

	//售后服务单编码")
	private String afServCode;

	//订单id")
	private Long orderId;


	//销售单id")
	private Long saleOrderId;

	//外部售后服务单号")
	private String extAfId;

	//外部订单编号")
	private String extOrderId;

	//服务类型             退货(10)、换货(20)、维修(30)")
	private Integer servType;

	//服务类型说明")
	private String servTypeDesc;

	//售后原因")
	private Integer afsReason;

	//服务方式")
	private Integer serviceWay;

	//服务方式名称")
	private String serviceWayName;

	//服务单状态             100提交申请             200 审核中             201审核不通过             300收货完成             400退款成功             401退款失败             500 已完成             600 取消")
	private Integer servState;

	//是否可取消             0：否             1：是")
	private Integer isCancel;

	//计量单位")
	private String unitName;

	//销售退款总金额")
	private BigDecimal retTotalSaleFee;

	//采购退款总金额")
	private BigDecimal retTotalPurchaseFee;

	//实际退款金额")
	private BigDecimal realReturnFee;

	//支付方式             1 预付款             2 电汇或承兑汇票             ")
	private String payType;

	//支付状态             1退款成功 0 退款失败 null 未处理")
	private Integer payState;

	//销售时间")
	private Date saleTime;

	//销售时间 开始")
	private Date saleTimeStart;

	//销售时间 结束")
	private Date saleTimeEnd;

	//服务提出时间")
	private Date submiteTime;

	//服务提出时间 开始")
	private Date submiteTimeStart;

	//服务提出时间 结束")
	private Date submiteTimeEnd;

	//服务提出人id")
	private String submitterOperId;

	//服务提出人名称")
	private String submitterOperName;

	//服务提出联系人")
	private String subContactName;

	//服务提出联系人电话")
	private String subContactMobile;

	//服务提出部门id")
	private String subDeptId;

	//服务提出部门名称")
	private String subDeptName;

	//服务提出公司id")
	private String subCompId;

	//服务提出公司名称")
	private String subCompName;

	//返件方式             （换、修这两种情况必填）")
	private Integer retMode;

	//取货服务类型             4：  上门取件             40：客户发货             7：  客户送货")
	private Integer pickwareType;

	//取货开始时间")
	private Date pickupStartTime;

	//取货开始时间 开始")
	private Date pickupStartTimeStart;

	//取货开始时间 结束")
	private Date pickupStartTimeEnd;

	//取货结束时间")
	private Date pickupEndTime;

	//取货结束时间 开始")
	private Date pickupEndTimeStart;

	//取货结束时间 结束")
	private Date pickupEndTimeEnd;

	//取货联系人id")
	private String pickupContactId;

	//收货联系人id")
	private String takeContactId;

	//租户ID")
	private String tenantId;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime2;

	//撤单时间 开始")
	private Date cancelTime2Start;

	//撤单时间 结束")
	private Date cancelTime2End;

	//撤单工号")
	private String cancelOperId2;

	//撤单原因")
	private String cancelReason2;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//取消人id")
	private String cancelOperId;

	//取消人名称")
	private String cancelOperName;

	//取消时间")
	private Date cancelTime;

	//取消时间 开始")
	private Date cancelTimeStart;

	//取消时间 结束")
	private Date cancelTimeEnd;

	//取消类型             1 申请人取消             2 供货商取消")
	private Integer cancelType;

	//取消原因")
	private String cancelReason;

	//供应商售后服务环节编码             申请阶段(10)             审核不通过(20)             客服审核(21)             商家审核(22)             京东收货(31)             商家收货(32)             京东处理(33)             商家处理(34)             用户确认(40)             完成(50)             取消 (60)")
	private String serviceStep;

	//供应商售后服务环节名称")
	private String serviceStepName;

	//完成时间")
	private Date finishTime;

	//完成时间 开始")
	private Date finishTimeStart;

	//完成时间 结束")
	private Date finishTimeEnd;

	//拒绝/确认备注")
	private String returnReason;

	//问题描述")
	private String questionDesc;

	//收货地址ID")
	private Long contactId;

	//三方电商换货/回寄维修操作新增订单的ID")
	private String extNewOrderId;

	//供应商确认时间")
	private Date confirmTime;

	//供应商确认时间 开始")
	private Date confirmTimeStart;

	//供应商确认时间 结束")
	private Date confirmTimeEnd;

	//扩展字段1")
	private String extField1;

	//扩展字段2")
	private String extField2;

	//扩展字段3")
	private String extField3;

	//扩展字段4")
	private String extField4;

	//扩展字段5")
	private String extField5;

	//排序")
	private String orderBy;
}
