package com.tydic.dyc.oc.model.chngorder.qrybo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderObjQryBo
 * 说明:变更单对象
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocChngOrderObjQryBo implements Serializable {
	private static final long serialVersionUID = 8095105689913380024L;

	//变更单对象id")
	private Long chngOrderObjId;

	//变更单id")
	private Long chngOrderId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;


	//发货单id")
	private Long shipOrderId;

	//验收单id")
	private Long inspOrderId;

	//变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更")
	private Integer chngType;

	//变更数量")
	private BigDecimal chngNum;

	//变更金额")
	private BigDecimal chngFee;

	//变更状态")
	private String chngState;

	//其他变更")
	private String otherChngValue;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//排序")
	private String orderBy;

	//变更单idList")
	private List<Long> chngOrderIdList;
}
