package com.tydic.dyc.oc.service.bargaining;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingItemBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateSupplierInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述：议价单申请服务
 *
 * @author Dum
 * @date 2023/7/29 16:37
 **/
@HTServiceImpl
@Slf4j
public class UocCreateBargainingServiceImpl implements UocCreateBargainingService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocCreateBargainingRspBo createBargaining(UocCreateBargainingReqBo reqBo) {
        //主订单创建
        UocBargainingParentDo bargainingParentDo = new UocBargainingParentDo();
        bargainingParentDo.setBargainingParentId(IdUtil.nextId());
        bargainingParentDo.setCreateTime(new Date());
        bargainingParentDo.setBargainingDesc(reqBo.getRemark());
        UocBargainingParentDo uocBargainingParentDo = this.uocBargainingModel.createBargainingParent(bargainingParentDo);
        log.info("父单结果：{}", JSON.toJSONString(uocBargainingParentDo));
        //议价单-调用拆分方法
        List<UocBargainingDo> bargainingDos= splitBargainingDo(reqBo,bargainingParentDo.getBargainingParentId());
        for (UocBargainingDo uocBargainingDo:bargainingDos) {
            this.uocBargainingModel.createBargaining(uocBargainingDo);
        }
        UocCreateBargainingRspBo uocCreateBargainingRspBo = new UocCreateBargainingRspBo();
        uocCreateBargainingRspBo.setBargainingParentId(String.valueOf(bargainingParentDo.getBargainingParentId()));
        return uocCreateBargainingRspBo;
    }
    /**
     * 根据供应商拆分议价单
     * @param reqBo
     */
    private List<UocBargainingDo> splitBargainingDo(UocCreateBargainingReqBo reqBo,Long bargainingParentId) {
        List<UocBargainingDo> uocBargainingDos = new ArrayList();
        //议价单明细
        Map<String, List<UocCreateBargainingItemBo>> bargainingItemMap = reqBo.getBargainingItemBos().stream().collect(Collectors.groupingBy(UocCreateBargainingItemBo::getSupplierId));
        //议价单地址信息
        UocBargainingAddress bargainingAddress = JSONObject.parseObject(JSON.toJSONString(reqBo.getAddressBo()), UocBargainingAddress.class);
        //对象拆分
        for (UocCreateSupplierInfoBo supplierInfoBo : reqBo.getSupplierBos()) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingParentId(bargainingParentId);
            uocBargainingDo.setQuotationExpiryTime(reqBo.getQuotationExpiryTime());
            uocBargainingDo.setBargainingOperId(String.valueOf(reqBo.getUserId()));
            uocBargainingDo.setBargainingOperName(reqBo.getName());
            uocBargainingDo.setSupId(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setSupplierName(supplierInfoBo.getSupplierName());
            uocBargainingDo.setPurOrgId(String.valueOf(reqBo.getOrgId()));
            uocBargainingDo.setPurOrgName(reqBo.getOrgName());
            uocBargainingDo.setPurCompanyId(String.valueOf(reqBo.getCompanyId()));
            uocBargainingDo.setPurCompanyName(reqBo.getCompanyName());
            uocBargainingDo.setBargainingAddress(bargainingAddress);
            uocBargainingDo.setModelSettle(reqBo.getModelSettle());
            List<UocCreateBargainingItemBo> createBargainingItemBos = bargainingItemMap.get(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setBargainingItems(JSONArray.parseArray(JSON.toJSONString(createBargainingItemBos)).toJavaList(UocBargainingItem.class));
            uocBargainingDos.add(uocBargainingDo);
        }
        return uocBargainingDos;
    }
}
