/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncTodo
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncTodo.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getTodoIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInstQryBo.setId(reqBo.getObjId());
        uocOrderTaskInstQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
            JSONObject orderTaskJson = JSON.parseObject((String)JSON.toJSONString((Object)uocOrderTaskInst));
            Map<String, Map<String, String>> dicMap = this.getDic();
            Map<String, String> objTypeMap = dicMap.get("UOC_ORDER_OBJ_TYPE");
            Map<String, String> dealTypeMap = dicMap.get("TASK_INST_DEAL_TYPE");
            Map<String, String> tacheCodeMap = dicMap.get("TACHE_CODE_TASK_NAME");
            orderTaskJson.put("orderNo", (Object)this.getOrderNo(uocOrderTaskInst));
            orderTaskJson.put("taskName", (Object)tacheCodeMap.get(uocOrderTaskInst.getProcState()));
            List<UocOrderTaskDeal> orderTaskDealList = this.getListTaskDeal(uocOrderTaskInst);
            if (!CollectionUtils.isEmpty(orderTaskDealList)) {
                UocOrderTaskDeal uocOrderTaskDeal = orderTaskDealList.get(0);
                orderTaskJson.put("objName", (Object)uocOrderTaskDeal.getDealName());
                if (null != uocOrderTaskDeal.getDealType()) {
                    orderTaskJson.put("objTypeStr", (Object)dealTypeMap.get(uocOrderTaskDeal.getDealType().toString()));
                }
            }
            orderTaskJson.put("procName", (Object)"\u6d41\u7a0b\u540d\u79f0");
            List<UocOrderProcInst> uocOrderProcInstList = this.getListProcInst(uocOrderTaskInst);
            if (!CollectionUtils.isEmpty(uocOrderProcInstList)) {
                UocOrderProcInst uocOrderProcInst = uocOrderProcInstList.get(0);
                orderTaskJson.put("procInstId", (Object)uocOrderProcInst.getProcInstId());
            }
            iUocEsSyncQryRspBo.setJsonObj(orderTaskJson);
        }
        return iUocEsSyncQryRspBo;
    }

    private String getOrderNo(UocOrderTaskInst uocOrderTaskInst) {
        if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInst.getObjType())) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(uocOrderTaskInst.getObjId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            if (null != uocSaleOrderDo) {
                return uocSaleOrderDo.getSaleOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInst.getObjType())) {
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocShipOrderQryBo.setShipOrderId(uocOrderTaskInst.getObjId());
            UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (null != uocShipOrderDo) {
                return uocShipOrderDo.getShipOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInst.getObjType())) {
            UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
            uocChngOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocChngOrderQryBo.setChngOrderId(uocOrderTaskInst.getObjId());
            UocChngOrderDo chngOrder = this.iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
            if (null != chngOrder) {
                return chngOrder.getChngOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInst.getObjType())) {
            // empty if block
        }
        return null;
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SHIP_ORDER_STATE");
        pCodes.add("UOC_ORDER_OBJ_TYPE");
        pCodes.add("TACHE_CODE_TASK_NAME");
        pCodes.add("TASK_INST_DEAL_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocOrderProcInst> getListProcInst(UocOrderTaskInst uocOrderTaskInst) {
        UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
        uocOrderProcInstQryBo.setOrderId(uocOrderTaskInst.getOrderId());
        uocOrderProcInstQryBo.setObjId(uocOrderTaskInst.getObjId());
        uocOrderProcInstQryBo.setObjType(uocOrderTaskInst.getObjType());
        return this.iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
    }

    private List<UocOrderTaskDeal> getListTaskDeal(UocOrderTaskInst uocOrderTaskInst) {
        UocOrderTaskDealQryBo uocOrderTaskDealQryBo = new UocOrderTaskDealQryBo();
        uocOrderTaskDealQryBo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        uocOrderTaskDealQryBo.setObjType(uocOrderTaskInst.getObjType());
        uocOrderTaskDealQryBo.setObjId(uocOrderTaskInst.getObjId());
        return this.iUocOrderModel.qryOrderTaskDealList(uocOrderTaskDealQryBo);
    }
}

