/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncBargaining
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncBargaining.class);
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getBargainingIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("syncSaleOrderReq,{}", (Object)JSON.toJSONString((Object)reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocBargainingDo bargainingObject = this.getBargainingObject(reqBo);
        if (Objects.isNull(bargainingObject)) {
            return rspBo;
        }
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        JSONObject bargainingObj = JSON.parseObject((String)JSON.toJSONString((Object)bargainingObject));
        rspBo.setJsonObj(bargainingObj);
        this.translateProperties(rspBo, dictionaryMap);
        log.info("\u9500\u552e\u5355es\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private static void initialize() {
        pCodeList.add("UOC_BARGAINING_STATE");
    }

    private void translateProperties(IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        JSONObject jsonObj = rspBo.getJsonObj();
        if (ObjectUtil.isNotEmpty(dictionaryMap) && ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_BARGAINING_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"bargainingState"))) {
            String bargainingState = jsonObj.getString("bargainingState");
            jsonObj.put("bargainingStateStr", (Object)dictionaryMap.get("UOC_BARGAINING_STATE").get(bargainingState));
        }
    }

    private UocBargainingDo getBargainingObject(IUocEsSyncQryReqBo reqBo) {
        UocBargainingQryBo uocBargainingQryBo = new UocBargainingQryBo();
        uocBargainingQryBo.setBargainingId(reqBo.getOrderId());
        uocBargainingQryBo.setPurOrgId(reqBo.getJsonObj().getString("purOrgId"));
        return this.uocBargainingModel.qryBargaining(uocBargainingQryBo);
    }

    static {
        UocEsSyncBargaining.initialize();
    }
}

