package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderInterLog
 * 说明:订单外部接口日志（其它中心或电商）领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderInterLog implements Serializable {
	private static final long serialVersionUID =  9082599844206281868L;

	//id")
	private Long id;

	//单据id                          单据类型为1=订单时，不填")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//接口流水")
	private String interSn;

	//接口编码")
	private String interCode;

	//流程正反向标志             1 正向             2 反向")
	private Integer flowFlag;

	//入参报文")
	private String inContent;

	//出参报文")
	private String outContent;

	//调用次数")
	private Integer callCount;

	//调用时间")
	private Date callTime;

	//调用时间 开始")
	private Date callTimeStart;

	//调用时间 结束")
	private Date callTimeEnd;

	//远端返回时间")
	private Date retTime;

	//远端返回时间 开始")
	private Date retTimeStart;

	//远端返回时间 结束")
	private Date retTimeEnd;

	//调用状态")
	private String callState;

	//异常编码")
	private String errCode;

	//异常描述")
	private String errDetail;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createLoginId;

	

}
