package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateApprovalOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;


/*
 * @Author lsl
 * @Description //TODO 创建审批单（新 交行）实现
 * @Date 16:01 2023/8/3
 * @Param
 * @return
 */

@Slf4j
@HTServiceImpl
public class UocCreateApprovalOrderServiceImpl implements UocCreateApprovalOrderService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Autowired
    private UocCommonRepository uocCommonRepository;
    
    @Override
    public UocCreateApprovalOrderServiceRspBo createApprovalOrder(UocCreateApprovalOrderServiceReqBo reqBo) {
        UocCreateApprovalOrderServiceRspBo rspBo = UocRu.success(UocCreateApprovalOrderServiceRspBo.class);
        //入参校验
        validateParm(reqBo);
        
        //1.查询订单(orderId)下所有的销售单列表
        List<UocSaleOrderDo> saleOrderDoList = getUocSaleOrderDos(reqBo);
    
        //2.查询订单(orderId)下所有的销售单是否都在 "审批中" 或者 "已取消"
        checkSaleOrderState(rspBo, saleOrderDoList);

        //不同归口部门下的销售单列表
        List<List<UocSaleOrderDo>>  relevantSaleOrderList = new ArrayList<>();
        //没有归口部门的销售单列表
        List<UocSaleOrderDo>  noRelevantSaleOrderList = new ArrayList<>();
    
        //3.根据审批单组装规则组装审批单数据：根据归口部门将“审批中”的销售单列表分组
        calculcateData(saleOrderDoList, relevantSaleOrderList,noRelevantSaleOrderList);
    
        //4.创建审批单
        if(!CollectionUtils.isEmpty(noRelevantSaleOrderList)){
            relevantSaleOrderList.add(noRelevantSaleOrderList);
        }
        
        for(List<UocSaleOrderDo> saleOrderDos: relevantSaleOrderList){
            long auditId = IdUtil.nextId();
    
            UocAuditOrderDo auditDo = new UocAuditOrderDo();
            auditDo.setOrderId(reqBo.getOrderId());
            auditDo.setAuditOrderId(auditId);
            auditDo.setAuditOrderStatus(UocStateConstants.AUDIT_PLUS_ORDER_STATUS.AUDITING);
            auditDo.setAuditOrderCode(genRequestCode());
            auditDo.setAuditOrderCode("审批测试单号");
            auditDo.setCreateTime(new Date());
            auditDo.setCreateOperId("1");
            auditDo.setCreateOperName("系统生成审批单");
    
            List<UocApprovalObj> objList = new ArrayList<>();
            auditDo.setApprovalObjs(objList);
            
            List<UocApprovalLog> uocApprovalLogList = new ArrayList<>();
            auditDo.setUocApprovalLogList(uocApprovalLogList);
            
            for (UocSaleOrderDo uocSaleOrderDo: saleOrderDos){
    
                UocApprovalObj approvalObj = new UocApprovalObj();
                approvalObj.setObjId(uocSaleOrderDo.getSaleOrderId().toString());
                approvalObj.setId(IdUtil.nextId());
                approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
                approvalObj.setOrderId(reqBo.getOrderId());
                approvalObj.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                objList.add(approvalObj);
    
                UocApprovalLog uocApprovalLog = new UocApprovalLog();
                uocApprovalLog.setAuditOrderId(auditId);
                uocApprovalLog.setId(IdUtil.nextId());
                uocApprovalLog.setCreateTime(new Date());
                uocApprovalLog.setObjNum(objList.size());
                uocApprovalLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
                uocApprovalLogList.add(uocApprovalLog);
                
            }
            
            iUocAuditOrderModel.saveAudit(auditDo);
        }

        return rspBo;
    }
    
    private String genRequestCode() {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.AUDIT_ORDER_NO);
    }
    
    private void calculcateData(List<UocSaleOrderDo> saleOrderDoList, List<List<UocSaleOrderDo>> relevantSaleOrderList,List<UocSaleOrderDo>  noRelevantSaleOrderList) {
    
        List<UocSaleOrderDo> auditingSaleOrderList = saleOrderDoList.stream().filter(e -> {
            if (UocStateConstants.SaleOrder.XS_SP_SPZ.equals(e.getSaleOrderState())) {
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        
        if(CollectionUtils.isEmpty(auditingSaleOrderList)){
            throw new ZTBusinessException("该订单下没有对应的“审批中”状态的销售单,暂不创建审批单");
        }
        
        List<Long> saleOrderIdList = auditingSaleOrderList.stream().map(UocSaleOrderDo::getSaleOrderId).collect(Collectors.toList());
        
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setSaleOrderIdList(saleOrderIdList);
        //查询销售单扩展
        List<UocSaleOrderMap> uocSaleOrderMapList = iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        //如果查询扩展为空，则直接将查询到销售单列表组成一个审批单，不用再按归口部门分组
        if(CollectionUtils.isEmpty(uocSaleOrderMapList)){
            relevantSaleOrderList.add(saleOrderDoList);
            return;
        }
        
        List<UocSaleOrderMap> noRelevantSaleMapList = new ArrayList<>();
        
        List<UocSaleOrderMap> relevantSaleMapList = uocSaleOrderMapList.stream().filter(e -> {
            if (ObjectUtil.isNotEmpty(e.getFieldCode()) && "relevantDeptId".equals(e.getFieldCode())) {
                return true;
            }
            noRelevantSaleMapList.add(e);
            return false;
        }).collect(Collectors.toList());
        
        //没有归口部门的销售单列表
        noRelevantSaleOrderList =  auditingSaleOrderList.stream().filter(e -> {
            boolean flag = false;
            for (UocSaleOrderMap saleOrderMap: noRelevantSaleMapList){
                if(saleOrderMap.getSaleOrderId().equals(e.getSaleOrderId())) flag =true;
            }
            return flag;
        }).collect(Collectors.toList());
        
        Map<String, List<UocSaleOrderMap>> relevantSaleMapMap = relevantSaleMapList.stream().collect(Collectors.groupingBy(UocSaleOrderMap::getFieldCode));
        
        
        for (Map.Entry<String, List<UocSaleOrderMap>> entry : relevantSaleMapMap.entrySet()) {
            List<UocSaleOrderDo>  uocSaleOrderDoList =  auditingSaleOrderList.stream().filter(e -> {
                boolean flag = false;
                for (UocSaleOrderMap saleOrderMap: entry.getValue()){
                    if(saleOrderMap.getSaleOrderId().equals(e.getSaleOrderId())) flag =true;
                }
                return flag;
            }).collect(Collectors.toList());
            
            relevantSaleOrderList.add(uocSaleOrderDoList);
        }
    }
    
    private List<UocSaleOrderDo> getUocSaleOrderDos(UocCreateApprovalOrderServiceReqBo reqBo) {
        UocSaleOrderDo qryDo = new UocSaleOrderDo();
        qryDo.setOrderId(reqBo.getOrderId());
        qryDo.setOrderSource(reqBo.getOrderSource());
        List<UocSaleOrderDo> saleOrderDoList = iUocSaleOrderModel.qrySaleOrderList(qryDo);
        return saleOrderDoList;
    }
    
    private void checkSaleOrderState(UocCreateApprovalOrderServiceRspBo rspBo, List<UocSaleOrderDo> saleOrderDoList) {
        boolean allCancelOrAuditing = true;
        for (UocSaleOrderDo uocSaleOrderDo : saleOrderDoList) {
            if (!UocStateConstants.SaleOrder.XS_SP_SPZ.equals(uocSaleOrderDo.getSaleOrderState()) && !UocStateConstants
                    .SaleOrder.XS_QX_QX.equals(uocSaleOrderDo.getSaleOrderState())) {
                allCancelOrAuditing = false;
            }
        }
        if (!allCancelOrAuditing) {
            throw new ZTBusinessException("该订单(orderId)下有状态不是”审批中“或“已取消”的销售订单");
        }
    }
    
    private void validateParm(UocCreateApprovalOrderServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new ZTBusinessException("订单id【orderId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("销售订单id【saleOrderId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderSource())) {
            throw new ZTBusinessException("订单来源【orderSource】不能为空");
        }
    }
}
