package com.tydic.dyc.oc.model.bargaining.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service
public class IUocBargainingModelImpl implements IUocBargainingModel {
    @Autowired
    private UocBargainingRepository uocBargainingRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Override
    public List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        if (null == uocBargainingQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryListBargaining(uocBargainingQryBo);
    }

    @Override
    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if(ObjectUtil.isEmpty(uocBargainingDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
        //议价单
        if (ObjectUtil.isEmpty(uocBargainingDo.getBargainingId())) {
            uocBargainingDo.setBargainingId(IdUtil.nextId());
        }
        //默认设置为刚创建状态
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingState())){
            uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_DBJ);//待报价
        }
        //编号
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingNo())){
            uocBargainingDo.setBargainingNo(genRequestCode());
        }
        //明细
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        //议价前商品总金额
        BigDecimal totalPrice =new BigDecimal(0);
        for (UocBargainingItem bargainingItem : bargainingItems) {
            bargainingItem.setBargainingId(uocBargainingDo.getBargainingId());
            if (ObjectUtil.isEmpty(bargainingItem.getBargainingItemId())) {
                bargainingItem.setBargainingItemId(IdUtil.nextId());
            }
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            //小计
            BigDecimal saleFee = bargainingItem.getSalePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setSaleFee(saleFee);
            totalPrice = saleFee.add(totalPrice);
            //冗余字段(组织机构查询使用)
            bargainingItem.setCreateTime(uocBargainingDo.getCreateTime());
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            bargainingItem.setPurCompanyId(uocBargainingDo.getPurCompanyId());
            bargainingItem.setBargainingNo(uocBargainingDo.getBargainingNo());
            bargainingItem.setPurOrgId(uocBargainingDo.getPurOrgId());
        }
        uocBargainingDo.setTotalPrice(totalPrice);
        //地址
        UocBargainingAddress uocBargainingAddress = uocBargainingDo.getBargainingAddress();
            uocBargainingAddress.setBargainingId(uocBargainingDo.getBargainingId());
            uocBargainingAddress.setAddressId(IdUtil.nextId());
        //为空创建一个
        if (null == uocBargainingDo.getCreateTime()) {
            uocBargainingDo.setCreateTime(new Date());
        }
            uocBargainingDo.setAddressId(uocBargainingAddress.getAddressId());
        return uocBargainingRepository.createBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        if (null == uocBargainingParentDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.createBargainingParent(uocBargainingParentDo);
    }

    @Override
    public UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo) {
        return uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    private String genRequestCode() {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_BARGAIN_NO);
    }
}
