package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 标题:UocEsSyncBargaining
 * 说明:议价单同步
 * 时间:2023/8/1 12:25
 * 作者:Dum
 */
@Slf4j
@Component
public class UocEsSyncBargaining implements IUocEsSync {

    protected static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return uocIndexConfig.getBargainingIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("syncSyncBargainingReq,{}", JSON.toJSONString(reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        //查询议价单主体
        UocBargainingDo bargainingObject = getBargainingObject(reqBo);
        if (Objects.isNull(bargainingObject)) {
            return rspBo;
        }
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        //议价单
        JSONObject bargainingObj = JSON.parseObject(JSON.toJSONString(bargainingObject));
        rspBo.setJsonObj(bargainingObj);
        //翻译
        translateProperties(rspBo, dictionaryMap);
        log.info("议价单es参数:{}", JSON.toJSONString(rspBo));
        return rspBo;
    }



    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        //议价单状态字典
        pCodeList.add(UocDicConstant.BARGAINING_STATE.P_CODE);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        //出参对象
        JSONObject jsonObj = rspBo.getJsonObj();
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            //议价单状态翻译
           if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.BARGAINING_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_BARGAINING_FIELD.BARGAINING_STATE))) {
                String bargainingState = jsonObj.getString(UocConstant.ES_BARGAINING_FIELD.BARGAINING_STATE);
                jsonObj.put(UocConstant.ES_BARGAINING_FIELD.BARGAINING_STATE_STR, dictionaryMap.get(UocDicConstant.BARGAINING_STATE.P_CODE).get(bargainingState));
            }
        }
    }
    /**
     * 查询议价单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.bargaining.UocBargainingDo
     */
    private UocBargainingDo getBargainingObject(IUocEsSyncQryReqBo reqBo) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBo.getOrderId());
        uocBargainingDo.setPurOrgId(reqBo.getJsonObj().getString("purOrgId"));
        return uocBargainingModel.qryBargaining(uocBargainingDo);
    }
}


