package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocRebargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocRebargainingRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @author DUM
 * @date 2023/8/8
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocRebargainingServiceImpl implements UocRebargainingService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocRebargainingRspBo executeRebargaining(UocRebargainingReqBo uocRebargainingReqBo) {
        //1 参数校验
        this.verifyParam(uocRebargainingReqBo);
        //2 .修改状态
        this.updateBargainingState(uocRebargainingReqBo);
        //3. 返回结果
        return UocRu.success(UocRebargainingRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocRebargainingReqBo reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单id不能为空");
        }
    }
    /**
     * 更新议价单单状态
     * @param reqBO
     */
    private void updateBargainingState(UocRebargainingReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_BJZ);
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.reBargaining(uocBargainingDo);
    }
}
