/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.notice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UocNoticeProcessorManager {
    private static final Logger log = LoggerFactory.getLogger(UocNoticeProcessorManager.class);
    private final Map<String, UocNoticeProcessor> manageMap = new ConcurrentHashMap<String, UocNoticeProcessor>();

    public void register(UocNoticeProcessor intObj) {
        String noticeCode = intObj.noticeCode();
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        Assert.notNull((Object)noticeCode, (String)"noticeCode can not be null");
        UocNoticeProcessor intRet = this.manageMap.get(noticeCode);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e0d\u540c\u901a\u77e5\u5b9e\u73b0\u7c7b(" + noticeCode + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(UocNoticeProcessorManager.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u901a\u77e5\u5b9e\u73b0\u7c7b\uff1a" + noticeCode);
        this.manageMap.put(noticeCode, intObj);
    }

    public UocNoticeProcessor getInstance(String noticeCode) {
        UocNoticeProcessor intRet = this.manageMap.get(noticeCode);
        if (intRet == null) {
            throw new BaseBusinessException("8888", "\u901a\u77e5\u5b9e\u73b0\u7c7b(" + noticeCode + ")\u4e0d\u5b58\u5728\uff01");
        }
        return intRet;
    }
}

