package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:订单领域服务-历史进度查询服务
 * 说明:
 * 时间:2023/7/26 15:19
 * 作者:gaoqh
 */
@HTServiceImpl
public class UocQryBargainingProgressRecordServiceImpl implements UocQryBargainingProgressRecordService {
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    /**
     * 历史进度查询服务
     */
    @Override
    public UocQryBargainingProgressRecordRspBo qryBargainingProgressRecord(UocQryBargainingProgressRecordReqBo reqBo) {
        validatebarg(reqBo);
        UocQryBargainingProgressRecordReqBo uocBargainingQryBo = new  UocQryBargainingProgressRecordReqBo();
        uocBargainingQryBo.setBargainingId(reqBo.getBargainingId());
        UocQryBargainingProgressRecordRspBo rsp = UocQryBargainingProgressRecordRspBo.builder().progressRecordBoList(uocBargainingModel.getList(uocBargainingQryBo)).build();
        return rsp;
    }

    private void validatebarg(UocQryBargainingProgressRecordReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[reqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getBargainingId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【议价主单id】不能为空");
        }

    }


}
