package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：EventConsumerCreateApprovalPlusOrder
 * 说明：创建(新)审批单同步
 * 时间：
 *
 * @author
 */
@Component
@Slf4j

public class EventConsumerCreateApprovalPlusOrder implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncApprovalPlusOrder->{}", JSON.toJSONString(map));
    
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = Long.valueOf((String) map.get("orderId"));
        if (ObjectUtil.isNotEmpty(orderId)) {
            Object auditOrderListObj = map.get("auditOrderList");
            if (ObjectUtil.isNotEmpty(auditOrderListObj)) {
                JSONArray auditOrderList = JSON.parseArray(JSON.toJSONString(auditOrderListObj));
                //审批单列表
                List<IUocEsSyncQryReqBo> auditList = new ArrayList<>();
            
                if(ObjectUtil.isNotEmpty(auditOrderList)){
                    for (int i = 0; i < auditOrderList.size(); i++) {
                        JSONObject arrayJson = auditOrderList.getJSONObject(i);
                        Long auditOrderId = arrayJson.getLong("auditOrderId");
                        if (auditOrderId != null) {
                            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                            syncQryReqBo.setOrderId(orderId);
                            syncQryReqBo.setObjId(auditOrderId);
                            auditList.add(syncQryReqBo);
                        }
                    }
                }
            
                //如果list不为空，则返给应用层
                if (ObjectUtil.isNotEmpty(auditList)) {
                    IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                    eventReqBo.setIndexName(uocIndexConfig.getApprovalOrderPlusIndex());
                    eventReqBo.setDataList(auditList);
                    retList.add(eventReqBo);
                }
            }
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_CREATE_APPROVAL_PLUS_SYNC;
    }
}
