package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @author DUM
 * @date 2023/8/7
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocCancelBargainingServiceImpl implements UocCancelBargainingService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    /**
     * 描述： 终止议价单
     *
     **/
    @Override
    public UocCancelBargainingRspBo cancelBargaining(UocCancelBargainingReqBo uocCancelBargainingReqBo) {
      //1 参数校验
        this.verifyParam(uocCancelBargainingReqBo);
      //2 .修改状态
        this.updateBargainingState(uocCancelBargainingReqBo);
      //3. 返回结果
        return UocRu.success(UocCancelBargainingRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocCancelBargainingReqBo reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getCancelReason())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "终止原因不能为空");
        }
    }
    /**
     * 更新议价单单状态
     * @param reqBO
     */
    private void updateBargainingState(UocCancelBargainingReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setCancelTime(new Date());
        uocBargainingDo.setCancelReason(reqBO.getCancelReason());
        uocBargainingDo.setCancelOperName(reqBO.getName());
        uocBargainingDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YZZ);
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.cancelBargaining(uocBargainingDo);
    }
}
