package com.tydic.dyc.oc.model.bargaining;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordRspBo;

import java.util.List;

/**
 * 标题:IUocBargainingModel
 * 说明:
 * 时间:2023/7/26 15:18
 * 作者:Dum
 */
public interface IUocBargainingModel {
    /**
     * 查议价单列表
     *
     * @param uocBargainingQryBo
     * @return
     */
    List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo);
    /**
     * 新增议价单列表
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 议价单父单列表
     *
     * @param uocBargainingParentDo
     * @return
     */
    UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo);

    /**
     * 查议价单列表（精准筛查）
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 更改议价单状态
     * @param uocBargainingDo
     * @return
     */
    void cancelBargaining(UocBargainingDo uocBargainingDo);

    /**
     * 描述:查询议价单信息
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo);

    /**
     * 描述:查询议价单明细信息
     * @param uocBargainingItemQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem></>
     * @return
     */
    List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo);
    /**
     * 修改，重新报价，修改状态报价中
     *
     * @param uocBargainingDo
     * @return
     */
    void reBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 查询，商品维度查询
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    BasePageRspBo<UocBargainingItem> getListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo);


    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<UocBargainingProgressRecordPO> 结果对象
     */
    List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo);


    /**
     * 根据条件查询单条数据
     *
     * @param reqBo  参数对象
     * @return UocBargainingAddressBo 结果对象
     */
    UocBargainingAddressBo getModelBy(UocBargaining reqBo);
}
