package com.tydic.dyc.oc.model.bargaining.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service
public class IUocBargainingModelImpl implements IUocBargainingModel {
    @Autowired
    private UocBargainingRepository uocBargainingRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Override
    public List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        if (null == uocBargainingQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryListBargaining(uocBargainingQryBo);
    }

    @Override
    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if(ObjectUtil.isEmpty(uocBargainingDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
        //议价单
        if (ObjectUtil.isEmpty(uocBargainingDo.getBargainingId())) {
            uocBargainingDo.setBargainingId(IdUtil.nextId());
        }
        //默认设置为刚创建状态
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingState())){
            uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_DBJ);//待报价
        }
        //编号
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingNo())){
            uocBargainingDo.setBargainingNo(genRequestCode());
        }
        //明细
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        //议价前商品总金额
        BigDecimal totalPrice =new BigDecimal(0);
        for (UocBargainingItem bargainingItem : bargainingItems) {
            bargainingItem.setBargainingId(uocBargainingDo.getBargainingId());
            if (ObjectUtil.isEmpty(bargainingItem.getBargainingItemId())) {
                bargainingItem.setBargainingItemId(IdUtil.nextId());
            }
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            //小计
            BigDecimal saleFee = bargainingItem.getSalePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setSaleFee(saleFee);
            totalPrice = saleFee.add(totalPrice);
            //冗余字段(组织机构查询使用)
            bargainingItem.setCreateTime(uocBargainingDo.getCreateTime());
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            bargainingItem.setPurCompanyId(uocBargainingDo.getPurCompanyId());
            bargainingItem.setBargainingNo(uocBargainingDo.getBargainingNo());
            bargainingItem.setPurOrgId(uocBargainingDo.getPurOrgId());
            bargainingItem.setBargainingOperName(uocBargainingDo.getBargainingOperName());
            bargainingItem.setPurOrgName(uocBargainingDo.getPurOrgName());
            bargainingItem.setSupplierName(uocBargainingDo.getSupplierName());
        }
        uocBargainingDo.setTotalPrice(totalPrice);
        //地址
        UocBargainingAddress uocBargainingAddress = uocBargainingDo.getBargainingAddress();
            uocBargainingAddress.setBargainingId(uocBargainingDo.getBargainingId());
            uocBargainingAddress.setAddressId(IdUtil.nextId());
        //为空赋值
        if (null == uocBargainingDo.getCreateTime()) {
            uocBargainingDo.setCreateTime(new Date());
        }
            uocBargainingDo.setAddressId(uocBargainingAddress.getAddressId());
        return uocBargainingRepository.createBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        if (null == uocBargainingParentDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.createBargainingParent(uocBargainingParentDo);
    }

    @Override
    public UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo) {
        return uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public void cancelBargaining(UocBargainingDo uocBargainingDo) {
        if (null == uocBargainingDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocBargainingDo.getBargainingId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参议价单ID不能为空");
        }
        if (null == uocBargainingDo.getCancelOperId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参终止人ID不能为空");
        }
        if (StringUtils.isEmpty(uocBargainingDo.getCancelReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参终止原因不能为空");
        }
        uocBargainingRepository.cancelBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo) {
        if (null == uocBargainingDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo) {
        if (null == uocBargainingItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryBargainingItemList(uocBargainingItemQryBo);
    }

    @Override
    public  void reBargaining(UocBargainingDo uocBargainingDo) {
        if (null == uocBargainingDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocBargainingDo.getBargainingId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参议价单ID不能为空");
        }
        if (null == uocBargainingDo.getCancelOperId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参终止人ID不能为空");
        }
        uocBargainingRepository.reBargaining(uocBargainingDo);
    }

    @Override
    public BasePageRspBo<UocBargainingItem> getListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo) {
        return uocBargainingRepository.qryListPageBargainingItem(uocBargainingItemQryBo);
    }
    /**
     * 生成议价单编号
     **/
    private String genRequestCode() {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_BARGAIN_NO);
    }

    @Override
    public List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo) {
        return uocBargainingRepository.getList(reqBo);
    }



    @Override
    public UocBargainingAddressBo getModelBy(UocBargaining reqBo) {
        return uocBargainingRepository.getModelBy(reqBo);
    }

}
