package com.tydic.dyc.oc.model.payorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderItemObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderMapQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.*;
import com.tydic.dyc.oc.repository.UocPayOrderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 标题:IUocPayOrderModel
 * 说明:支付单
 * 时间:2022/2/23 14:01
 * 作者:tkl
 */

@Service
public class IUocPayOrderModelImpl implements IUocPayOrderModel {

    @Autowired
    private UocPayOrderRepository uocPayOrderRepository;

    @Override
    public UocPayOrder getPayOrderMain(UocPayOrderQryBo uocPayOrderQryBo) {
        if (ObjectUtil.isNull(uocPayOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getPayOrderMain(uocPayOrderQryBo);
    }

    @Override
    public List<UocPayOrder> getListPayOrder(UocPayOrderQryBo uocPayOrderQryBo) {
        if (ObjectUtil.isNull(uocPayOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrder(uocPayOrderQryBo);
    }

    @Override
    public List<UocPayOrderObj> getListPayOrderObj(UocPayOrderObjQryBo uocPayOrderObjQryBo) {
        if (ObjectUtil.isNull(uocPayOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderObj(uocPayOrderObjQryBo);
    }

    @Override
    public List<UocPayOrderItemObj> getListPayOrderItemObj(UocPayOrderItemObjQryBo uocPayOrderItemObjQryBo) {
        if (ObjectUtil.isNull(uocPayOrderItemObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderItemObj(uocPayOrderItemObjQryBo);
    }

    @Override
    public List<UocPayOrderMap> getListPayOrderMap(UocPayOrderMapQryBo uocPayOrderMapQryBo) {
        if (ObjectUtil.isNull(uocPayOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderMap(uocPayOrderMapQryBo);
    }

    @Override
    public void modifyPayOrderMain(UocPayOrderQryBo set,UocPayOrderQryBo where) {
        if (ObjectUtil.isNull(set) || ObjectUtil.isNull(where)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "设置值和设置条件均不能为空");
        }
        uocPayOrderRepository.modifyPayOrderMain(set,where);

    }

    /**
     * 创建订单应付单
     * @param uocOrderShouldPay 入参
     */
    @Override
    public void createShouldPayOrder(UocOrderShouldPay uocOrderShouldPay) {
        createShouldPayOrderVal(uocOrderShouldPay);
        if(ObjectUtil.isEmpty(uocOrderShouldPay.getPaidAmount())){
            uocOrderShouldPay.setPaidAmount(new BigDecimal(0));
        }
        uocPayOrderRepository.createShouldPayOrder(uocOrderShouldPay);
    }

    /**
     * 根据条件获取一条应付单数据
     *
     * @param uocOrderShouldPay 查询条件
     * @return 一条应付单数据
     */
    @Override
    public UocOrderShouldPay getOrderShouldPay(UocOrderShouldPay uocOrderShouldPay) {
        if (null == uocOrderShouldPay) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getOrderShouldPay(uocOrderShouldPay);
    }

    /**
     * 查询多条应付单数据
     *
     * @param uocOrderShouldPay 查询条件
     * @return 多条应付单数据
     */
    @Override
    public List<UocOrderShouldPay> getListOrderShouldPay(UocOrderShouldPay uocOrderShouldPay) {
        if (null == uocOrderShouldPay) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListOrderShouldPay(uocOrderShouldPay);
    }

    /**
     * 订单应付单主体数据更新
     *
     * @param set
     * @param where
     */
    @Override
    public void modifyOrderShouldPayMain(UocOrderShouldPay set, UocOrderShouldPay where) {
        if (set == null || where == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        uocPayOrderRepository.modifyOrderShouldPayMain(set, where);
    }

    private void createShouldPayOrderVal(UocOrderShouldPay uocOrderShouldPay) {
        if(uocOrderShouldPay == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(uocOrderShouldPay.getShouldPayId() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参结算应付ID不能为空");
        }
        if(uocOrderShouldPay.getPayType() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参付款方式不能为空");
        }
        if(uocOrderShouldPay.getShouldPayType() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参应付类型不能为空");
        }
        if(uocOrderShouldPay.getObjectId() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参单据ID不能为空");
        }
        if(uocOrderShouldPay.getObjectNo() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参单据编码不能为空");
        }
        if(uocOrderShouldPay.getOrderId() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if(uocOrderShouldPay.getObjectType() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参单据类型不能为空");
        }
        if(uocOrderShouldPay.getShouldPayAmount() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参应付金额不能为空");
        }
    }
}
