package com.tydic.dyc.oc.repository;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.order.qrybo.ConfSupplierQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordRspBo;
import com.tydic.dyc.oc.utils.UocRu;

import java.util.List;

/**
 * 标题:UocBargainingRepository
 * 说明:议价单
 * 时间:2023/7/26 15:51
 * 作者:Dum
 */
public interface UocBargainingRepository {
    /**
     * 查询议价单列表
     *
     * @param uocBargainingQryBo
     * @return
     */
    List<UocBargaining> qryListBargaining(UocBargainingQryBo uocBargainingQryBo);
    /**
     * 申请议价单
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 申请议价单
     *
     * @param uocBargainingParentDo
     * @return
     */
    UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo);
    /**
     * 查询，同步议价单
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo);
    /**
     * 修改，修改议价单状态
     *
     * @param uocBargainingDo
     * @return
     */
    void cancelBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 查询，查询商品最新报价列表
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo);
    /**
     * 修改，修改状态报价中
     *
     * @param uocBargainingDo
     * @return
     */
    void reBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 查询 商品列表（运营商维度）
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    BasePageRspBo<UocBargainingItem> qryListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo);

    /**
     * 根据条件查询列表数据
     *
     * @param reqBo  参数对象
     * @return List<UocBargainingProgressRecordPO> 结果对象
     */
    List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo);


    /**
     * 根据条件查询单条数据
     *
     * @param reqBo  参数对象
     * @return UocBargainingAddressBo 结果对象
     */
    UocBargainingAddressBo getModelBy(UocBargaining reqBo);
}
