package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author gaoqh646
 * @date 2023/8/7
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocQryBargainingDetailServiceImpl implements UocQryBargainingDetailService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Override
    public UocQryBargainingDetailRspBo qryBargainingDetail(UocQryBargainingDetailReqBo reqBo) {
        verifyParam(reqBo);
        UocBargainingDo qryDo=UocRu.js(reqBo, UocBargainingDo.class);

        UocBargainingDo uocBargainingDo = uocBargainingModel.qryBargainingBy(qryDo);
        UocQryBargainingDetailRspBo rspBo = UocRu.js(uocBargainingDo, UocQryBargainingDetailRspBo.class);

        UocBargainingAddressBo addressBo = uocBargainingModel.getModelBy(UocBargaining.builder().bargainingId(uocBargainingDo.getBargainingId()).addressId(uocBargainingDo.getAddressId()).build());
        rspBo.setBargainingAddress(addressBo);
        return rspBo;
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocQryBargainingDetailReqBo reqBo) {
        if(null == reqBo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBo.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单ID不能为空");
        }

    }

}
