/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.service.bargaining.UocRebargainingService;
import com.tydic.dyc.oc.service.bargaining.bo.UocRebargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocRebargainingRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocRebargainingService"})
public class UocRebargainingServiceImpl
implements UocRebargainingService {
    private static final Logger log = LoggerFactory.getLogger(UocRebargainingServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"executeRebargaining"})
    public UocRebargainingRspBo executeRebargaining(@RequestBody UocRebargainingReqBo uocRebargainingReqBo) {
        this.verifyParam(uocRebargainingReqBo);
        this.verifyState(uocRebargainingReqBo);
        this.updateBargainingState(uocRebargainingReqBo);
        return UocRu.success(UocRebargainingRspBo.class);
    }

    private void verifyState(UocRebargainingReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = this.uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if (!"YJ_YBJ".equals(bargainingDo.getBargainingState())) {
            throw new BaseBusinessException("102001", "\u4e0d\u80fd\u53d1\u91cd\u65b0\u62a5\u4ef7\uff0c\u8bae\u4ef7\u5355\u72b6\u6001\u975e\u5df2\u62a5\u4ef7\uff01");
        }
    }

    private void verifyParam(UocRebargainingReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBargainingId()) {
            throw new BaseBusinessException("102001", "\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateBargainingState(UocRebargainingReqBo reqBO) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setBargainingState("YJ_BJZ");
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.reBargaining(uocBargainingDo);
    }
}

