package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationItemBO;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author DUM
 * @date 2023/8/14
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocMsgHandleQuotationServiceImpl implements UocMsgHandleQuotationService {

    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocMsgHandleQuotationRspBo dealQuotation(UocMsgHandleQuotationReqBo reqBo) {
        UocMsgHandleQuotationRspBo rspBo = UocRu.success(UocMsgHandleQuotationRspBo.class);
        //校验
        validateBo(reqBo);
        //转换
        UocBargainingQuotationDo uocBargainingQuotationDo =assembleUpdateDo(reqBo);
        //计算总结，小计
        calculateTotal(uocBargainingQuotationDo);
        // 更新报价明细
        uocBargainingModel.updateQuotationItemWithSkuId(uocBargainingQuotationDo);
        //更新报价
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
        quotationDo.setQuotationId(uocBargainingQuotationDo.getQuotationId());
        quotationDo.setQuotationStatus("1");
        quotationDo.setTotalConfirmedPrice(uocBargainingQuotationDo.getTotalConfirmedPrice());
        quotationDo.setSavedPrice(uocBargainingQuotationDo.getSavedPrice());
        uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        //更新议价单主单状态
        UocBargainingDo uocBargainingDo =new UocBargainingDo();
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YBJ);
        uocBargainingDo.setTotalConfirmedPrice(uocBargainingQuotationDo.getTotalConfirmedPrice());
        uocBargainingDo.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        uocBargainingModel.updateBargaining(uocBargainingDo);
        //记录操作动作
        insertProgressRecord(uocBargainingQuotationDo);
        //出参
        rspBo.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        rspBo.setTaskId(getTaskInstId(quotationDo));
        return rspBo;
    }
    /**
     * 转换对象
     **/
    private UocBargainingQuotationDo assembleUpdateDo(UocMsgHandleQuotationReqBo reqBo) {
        UocBargainingQuotationBo uocBargainingQuotationBo = new UocBargainingQuotationBo();
        uocBargainingQuotationBo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        UocBargainingQuotationBo quotationBo = uocBargainingModel.getQuotationBy(uocBargainingQuotationBo);
        //对象转换
        UocBargainingQuotationDo bargainingQuotationDo = new UocBargainingQuotationDo();
        //回传议价ID
        bargainingQuotationDo.setBargainingId(quotationBo.getBargainingId());
        bargainingQuotationDo.setTotalOriginalPrice(quotationBo.getTotalOriginalPrice());
        bargainingQuotationDo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        bargainingQuotationDo.setBiddingCode(reqBo.getBiddingCode());
        bargainingQuotationDo.setBiddingStatus(reqBo.getBiddingCode());
        bargainingQuotationDo.setOrderDeadLine(reqBo.getOrderDeadLine());
        List<UocMsgHandleQuotationItemBO> skuItem = reqBo.getSkuInfoList();
        List<UocBargainingQuotationItem> quotationItemList = new ArrayList<>();
        bargainingQuotationDo.setBargainingQuotationItems(quotationItemList);
        for (UocMsgHandleQuotationItemBO skuBo : skuItem) {
            UocBargainingQuotationItem item = new UocBargainingQuotationItem();
            item.setQuotationId(bargainingQuotationDo.getQuotationId());
            item.setSkuId(Long.valueOf(skuBo.getThirdSkuUid()));
            item.setExtSkuId(String.valueOf(skuBo.getSkuId()));
            item.setConfirmedPrice(skuBo.getConfirmedPrice());
            item.setSkuName(skuBo.getSkuName());
            item.setSkuNum(skuBo.getSkuNum());
            item.setConfirmedBrandName(skuBo.getConfirmedBrandName());
            item.setConfirmedModel(skuBo.getConfirmedModel());
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setTaxRate(skuBo.getTaxRate());
            item.setNakedPrice(skuBo.getNakedPrice());
            item.setGreenFlag(skuBo.getGreenFlag());
            item.setGreenFlagDesc(skuBo.getGreenFlagDesc());
            item.setMicroCompanyFlag(skuBo.getMicroCompanyFlag());
            item.setMicroCompanyFlagDesc(skuBo.getMicroCompanyFlagDesc());
            quotationItemList.add(item);
        }
        return bargainingQuotationDo;
    }
    /**
     * 参数校验
     */
    private void validateBo(UocMsgHandleQuotationReqBo quotationReqBo) {
        if (quotationReqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(quotationReqBo.getThirdApplyId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[议价单ID]不能为空");
        }
        List<UocMsgHandleQuotationItemBO> quotationItems = quotationReqBo.getSkuInfoList();
        if (ObjectUtil.isEmpty(quotationItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细]不能为空");
        }
        for (UocMsgHandleQuotationItemBO quotationItemBO : quotationItems) {
            if (ObjectUtil.isEmpty(quotationItemBO.getThirdSkuUid())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细行号（SkuID）]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细单品ID]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getConfirmedPrice())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[报价明细-报价]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuName]不能为空");
            }
            if (ObjectUtil.isEmpty(quotationItemBO.getSkuNum())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuNum]不能为空");
            }
        }
    }

    /**
     * 计算（小计/合计/差异率）
     */
    private void calculateTotal(UocBargainingQuotationDo quotationDo) {
        //议价前商品总金额
        BigDecimal totalOriginalPrice = quotationDo.getTotalOriginalPrice();
        //报价总金额
        BigDecimal totalConfirmedPrice = new BigDecimal(0);
        for (UocBargainingQuotationItem quotationItem : quotationDo.getBargainingQuotationItems()) {
           BigDecimal confirmedPriceSub = quotationItem.getConfirmedPrice().divide(new BigDecimal(quotationItem.getSkuNum().intValue()));
            quotationItem.setConfirmedPriceSub(confirmedPriceSub); //设置报价小计
            totalConfirmedPrice = totalConfirmedPrice.add(confirmedPriceSub);
           quotationItem.setConfirmedPriceSub(confirmedPriceSub);
        }
        // 节省金额
        BigDecimal savedPrice = totalOriginalPrice.subtract(totalConfirmedPrice);
        quotationDo.setTotalConfirmedPrice(totalConfirmedPrice);
        quotationDo.setSavedPrice(savedPrice);
    }


    private String getTaskInstId(UocBargainingQuotationDo quotationDo) {
        String taskId ="";
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(quotationDo.getBargainingId());
        taskInstQryBo.setObjId(quotationDo.getBargainingId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isEmpty(taskInsts)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "议价单报价业务失败：未查询到任务表信息!");
        }
        taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
        log.info("议价流程流程数据：{}", JSON.toJSONString(taskInsts));
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            taskId = taskInsts.get(0).getTaskInstId();
        }
        return taskId;
    }

    /**
     * 记录操作动作
     * @param quotationDo
     */
    private void insertProgressRecord(UocBargainingQuotationDo quotationDo){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(quotationDo.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CANCEL);
        recordDo.setOperTypeName("报价完成");
        recordDo.setOperId(1111l);
        recordDo.setOperName("自动任务");
        recordDo.setOperTime(new Date());
        uocBargainingModel.insertProgressRecord(recordDo);
    }
}
