/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.bargaining.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingProgressRecordReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryQuotationListServiceReqBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IUocBargainingModelImpl
implements IUocBargainingModel {
    @Autowired
    private UocBargainingRepository uocBargainingRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Override
    public List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        if (null == uocBargainingQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocBargainingRepository.qryListBargaining(uocBargainingQryBo);
    }

    @Override
    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if (ObjectUtil.isEmpty((Object)uocBargainingDo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingId())) {
            uocBargainingDo.setBargainingId(IdUtil.nextId());
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingState())) {
            uocBargainingDo.setBargainingState("YJ_BJZ");
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getQuoteMaxRound())) {
            uocBargainingDo.setQuoteCurrentRound(new Integer(3));
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getQuoteCurrentRound())) {
            uocBargainingDo.setQuoteCurrentRound(new Integer(1));
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingNo())) {
            uocBargainingDo.setBargainingNo(this.genRequestCode());
        }
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        BigDecimal totalPrice = new BigDecimal(0);
        for (UocBargainingItem bargainingItem : bargainingItems) {
            bargainingItem.setBargainingId(uocBargainingDo.getBargainingId());
            if (ObjectUtil.isEmpty((Object)bargainingItem.getBargainingItemId())) {
                bargainingItem.setBargainingItemId(IdUtil.nextId());
            }
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            BigDecimal saleFee = bargainingItem.getSalePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setSaleFee(saleFee);
            totalPrice = saleFee.add(totalPrice);
            bargainingItem.setCreateTime(uocBargainingDo.getCreateTime());
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            bargainingItem.setPurCompanyId(uocBargainingDo.getPurCompanyId());
            bargainingItem.setBargainingNo(uocBargainingDo.getBargainingNo());
            bargainingItem.setPurOrgId(uocBargainingDo.getPurOrgId());
            bargainingItem.setBargainingOperName(uocBargainingDo.getBargainingOperName());
            bargainingItem.setPurOrgName(uocBargainingDo.getPurOrgName());
            bargainingItem.setSupplierName(uocBargainingDo.getSupplierName());
        }
        uocBargainingDo.setTotalPrice(totalPrice);
        UocBargainingAddress uocBargainingAddress = uocBargainingDo.getBargainingAddress();
        uocBargainingAddress.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingAddress.setAddressId(IdUtil.nextId());
        if (null == uocBargainingDo.getCreateTime()) {
            uocBargainingDo.setCreateTime(new Date());
        }
        uocBargainingDo.setAddressId(uocBargainingAddress.getAddressId());
        return this.uocBargainingRepository.createBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        if (null == uocBargainingParentDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocBargainingRepository.createBargainingParent(uocBargainingParentDo);
    }

    @Override
    public UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo) {
        return this.uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public void updateBargaining(UocBargainingDo uocBargainingDo) {
        this.uocBargainingRepository.updateBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo) {
        if (null == uocBargainingDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo) {
        if (null == uocBargainingItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocBargainingRepository.qryBargainingItemList(uocBargainingItemQryBo);
    }

    @Override
    public BasePageRspBo<UocBargainingItem> getListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo) {
        return this.uocBargainingRepository.qryListPageBargainingItem(uocBargainingItemQryBo);
    }

    private String genRequestCode() {
        return this.uocCommonRepository.getOrderNoSingle("ORDER_BARGAIN_NO");
    }

    @Override
    public List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo) {
        return this.uocBargainingRepository.getList(reqBo);
    }

    @Override
    public UocBargainingAddressBo getModelBy(UocBargaining reqBo) {
        return this.uocBargainingRepository.getModelBy(reqBo);
    }

    @Override
    public List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo) {
        return this.uocBargainingRepository.qryListBargainingQuotatio(reqBo);
    }

    @Override
    public UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo) {
        return this.uocBargainingRepository.qryBargainingItemPage(reqBo);
    }

    @Override
    public UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        if (null == uocBargainingQuotationDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocBargainingRepository.createQuotation(uocBargainingQuotationDo);
    }

    @Override
    public void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        if (null == uocBargainingQuotationDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocBargainingQuotationDo.getQuotationId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u62a5\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocBargainingRepository.updateQuotation(uocBargainingQuotationDo);
    }

    @Override
    public void updateQuotationItemWithSkuId(UocBargainingQuotationDo uocBargainingQuotationDo) {
        this.uocBargainingRepository.updateQuotationItem(uocBargainingQuotationDo);
    }

    @Override
    public UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo) {
        return this.uocBargainingRepository.getQuotationBy(uocBargainingQuotationBo);
    }

    @Override
    public void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo) {
        this.uocBargainingRepository.insertProgressRecord(uocBargainingProgressRecordDo);
    }
}

