package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述：议价单历史详情和最新报价-查询服务
 *
 * @author gaoqh646
 * @date 2023/8/7
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocQryBargainingItemServiceImpl implements UocQryBargainingItemService {

    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @Override
    public UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo) {
        verifyParam(reqBo);
        UocBargainingItemPageRspBo respBO = uocBargainingModel.qryBargainingItemPage(reqBo);
        return respBO;
    }

    /**
     * 参数校验
     *
     * @param reqBo
     */
    private void verifyParam(UocBargainingItemPageReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if ("1".equals(reqBo.getInterfaceType())) {
//            if (ObjectUtil.isEmpty(reqBo.getBargainingId())) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单ID不能为空");
//            }

            if (ObjectUtil.isEmpty(reqBo.getQuotationId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "报价单ID不能为空");
            }
        } else if ("2".equals(reqBo.getInterfaceType())) {

        }
    }

}
