/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocEsSyncApprovalPlus
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncApprovalPlus.class);
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getApprovalOrderPlusIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocAuditOrderDo uocAuditOrderDo = this.getUocAuditOrderDo(reqBo);
        if (null == uocAuditOrderDo) {
            return iUocEsSyncQryRspBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDic();
        List<UocApprovalObj> uocApprovalObjList = this.getAuditOrderObjList(reqBo);
        JSONObject auditOrderJson = JSON.parseObject((String)JSON.toJSONString((Object)uocAuditOrderDo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!CollectionUtils.isEmpty(uocApprovalObjList)) {
            for (UocApprovalObj uocApprovalObj : uocApprovalObjList) {
                UocGetSaleOrderDetailServiceRspPorcBo auditBusiProcInst;
                if (UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObj.getObjType())) {
                    List<UocSaleOrderMap> saleOrderMapList;
                    UocSaleOrderDo saleOrder = this.getSaleOrder(uocApprovalObj);
                    if (null != saleOrder) {
                        Map<String, String> payType = dicMap.get("UOC_SALE_ORDER_PAY_TYPE");
                        Map<String, String> saleOrderState = dicMap.get("UOC_SALE_ORDER_STATE");
                        saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                        saleOrder.setPayTypeStr(payType.get(saleOrder.getPayType()));
                        saleOrder.setModelSettleStr(null != saleOrder.getModelSettle() ? dicMap.get("UOC_COMMON_MODEL_SETTLE").get(saleOrder.getModelSettle() != null ? saleOrder.getModelSettle().toString() : saleOrder.getModelSettle()) : "");
                        List<UocSaleOrderItem> uocSaleOrderItemList = this.getListSaleOrderItem(uocApprovalObj);
                        saleOrder.setSaleOrderItems(uocSaleOrderItemList);
                        auditOrderJson.put("saleOrderInfo", (Object)saleOrder);
                        auditOrderJson.put("orderCreateTime", (Object)saleOrder.getCreateTime());
                        auditOrderJson.put("orderCreateOperId", (Object)saleOrder.getCreateOperId());
                        auditOrderJson.put("orderCreateOperName", (Object)saleOrder.getCreateOperName());
                    }
                    if (null != (saleOrderMapList = this.getSaleOrderMapList(uocApprovalObj))) {
                        saleOrderMapList.forEach(each -> auditOrderJson.put(each.getFieldCode(), (Object)each.getFieldValue()));
                    }
                }
                auditOrderJson.put("auditProcInstId", (Object)(ObjectUtil.isNotEmpty((Object)(auditBusiProcInst = this.getProcInst(uocApprovalObj, true)).getProcInstId()) ? auditBusiProcInst.getProcInstId() : ""));
                auditOrderJson.put("auditTaskList", (Object)(ObjectUtil.isNotEmpty((Object)auditBusiProcInst.getTaskList()) ? auditBusiProcInst.getTaskList() : new ArrayList()));
                this.translateProperties(auditOrderJson, dicMap);
            }
        }
        iUocEsSyncQryRspBo.setJsonObj(auditOrderJson);
        log.info("\u65b0\u5ba1\u6279\u5355\u540c\u6b65es\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)iUocEsSyncQryRspBo));
        return iUocEsSyncQryRspBo;
    }

    private void translateProperties(JSONObject jsonObj, Map<String, Map<String, String>> dictionaryMap) {
        if (ObjectUtil.isNotEmpty(dictionaryMap) && null != dictionaryMap.get("UOC_PRO_BUDGET_MODEL") && null != jsonObj.get((Object)"budgetModelCode")) {
            jsonObj.put("budgetModelName", (Object)dictionaryMap.get("UOC_PRO_BUDGET_MODEL").get(jsonObj.getString("budgetModelCode")));
        }
    }

    private List<UocSaleOrderMap> getSaleOrderMapList(UocApprovalObj reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(Convert.toLong((Object)reqBo.getObjId()));
        return this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private UocAuditOrderDo getUocAuditOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
        uocAuditOrderQryBo.setAuditOrderId(reqBo.getObjId());
        uocAuditOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
    }

    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrder.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrder.getAgrDataId());
        return this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        saleOrderObj.put("agreementCode", (Object)agreement.getAgreementCode());
        saleOrderObj.put("plaAgreementCode", (Object)agreement.getPlaAgreementCode());
        saleOrderObj.put("agreementName", (Object)agreement.getAgreementName());
    }

    private List<UocApprovalObj> getAuditOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getObjId());
        return this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocApprovalObj uocApprovalObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(Convert.toLong((Object)uocApprovalObj.getObjId()));
        uocSaleOrderQryBo.setOrderId(uocApprovalObj.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocApprovalObj uocApprovalObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(Convert.toLong((Object)uocApprovalObj.getObjId()));
        uocSaleOrderItemQryBo.setOrderId(uocApprovalObj.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_STATE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("UOC_COMMON_MODEL_SETTLE");
        pCodes.add("UOC_AUDIT_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocApprovalObj uocApprovalObj, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjType(uocApprovalObj.getObjType());
        }
        procInstQryBo.setObjId(Convert.toLong((Object)uocApprovalObj.getObjId()));
        procInstQryBo.setOrderId(uocApprovalObj.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            Map<Integer, List<UocOrderTaskInst>> taskIntsMap = uocOrderTaskInsts.stream().collect(Collectors.groupingBy(UocOrderTaskInst::getFinishTag));
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(taskIntsMap.get(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED))) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}

