/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.service.bargaining.UocCreateBargainingService;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingCreateResultBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingItemBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateSupplierInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocCreateBargainingService"})
public class UocCreateBargainingServiceImpl
implements UocCreateBargainingService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateBargainingServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"createBargaining"})
    public UocCreateBargainingRspBo createBargaining(@RequestBody UocCreateBargainingReqBo reqBo) {
        UocBargainingParentDo bargainingParentDo = new UocBargainingParentDo();
        bargainingParentDo.setBargainingParentId(IdUtil.nextId());
        bargainingParentDo.setCreateTime(new Date());
        bargainingParentDo.setBargainingDesc(reqBo.getRemark());
        UocBargainingParentDo uocBargainingParentDo = this.uocBargainingModel.createBargainingParent(bargainingParentDo);
        log.info("\u7236\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)uocBargainingParentDo));
        List<UocBargainingDo> bargainingDos = this.splitBargainingDo(reqBo, bargainingParentDo.getBargainingParentId());
        ArrayList<UocBargainingCreateResultBo> uocBargainingList = new ArrayList<UocBargainingCreateResultBo>();
        for (UocBargainingDo uocBargainingDo : bargainingDos) {
            UocBargainingDo bargainingDo = this.uocBargainingModel.createBargaining(uocBargainingDo);
            UocBargainingCreateResultBo bargainingCreateResultBo = new UocBargainingCreateResultBo();
            bargainingCreateResultBo.setBargainingId(bargainingDo.getBargainingId());
            bargainingCreateResultBo.setBargainingNo(bargainingDo.getBargainingNo());
            bargainingCreateResultBo.setPurOrgId(bargainingDo.getPurOrgId());
            uocBargainingList.add(bargainingCreateResultBo);
            this.initBargainingQuotation(bargainingDo);
        }
        UocCreateBargainingRspBo uocCreateBargainingRspBo = new UocCreateBargainingRspBo();
        uocCreateBargainingRspBo.setBargainingParentId(String.valueOf(bargainingParentDo.getBargainingParentId()));
        uocCreateBargainingRspBo.setUocBargainingList(uocBargainingList);
        return uocCreateBargainingRspBo;
    }

    private List<UocBargainingDo> splitBargainingDo(UocCreateBargainingReqBo reqBo, Long bargainingParentId) {
        ArrayList<UocBargainingDo> uocBargainingDos = new ArrayList<UocBargainingDo>();
        Map<String, List<UocCreateBargainingItemBo>> bargainingItemMap = reqBo.getBargainingItemBos().stream().collect(Collectors.groupingBy(UocCreateBargainingItemBo::getSupplierId));
        UocBargainingAddress bargainingAddress = (UocBargainingAddress)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo.getAddressBo()), UocBargainingAddress.class);
        for (UocCreateSupplierInfoBo supplierInfoBo : reqBo.getSupplierBos()) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingParentId(bargainingParentId);
            uocBargainingDo.setQuotationExpiryTime(reqBo.getQuotationExpiryTime());
            uocBargainingDo.setBargainingOperId(String.valueOf(reqBo.getUserId()));
            uocBargainingDo.setBargainingOperName(reqBo.getName());
            uocBargainingDo.setSupId(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setSupplierName(supplierInfoBo.getSupplierName());
            uocBargainingDo.setPurOrgId(String.valueOf(reqBo.getOrgId()));
            uocBargainingDo.setPurOrgName(reqBo.getOrgName());
            uocBargainingDo.setPurCompanyId(String.valueOf(reqBo.getCompanyId()));
            uocBargainingDo.setPurCompanyName(reqBo.getCompanyName());
            uocBargainingDo.setBargainingAddress(bargainingAddress);
            uocBargainingDo.setModelSettle(reqBo.getModelSettle());
            List<UocCreateBargainingItemBo> createBargainingItemBos = bargainingItemMap.get(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setBargainingItems(JSONArray.parseArray((String)JSON.toJSONString(createBargainingItemBos)).toJavaList(UocBargainingItem.class));
            uocBargainingDos.add(uocBargainingDo);
        }
        return uocBargainingDos;
    }

    private void initBargainingQuotation(UocBargainingDo bargainingDo) {
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
        quotationDo.setQuotationId(IdUtil.nextId());
        quotationDo.setBargainingId(bargainingDo.getBargainingId());
        quotationDo.setCreateTime(new Date());
        quotationDo.setQuotationExpiryTime(bargainingDo.getQuotationExpiryTime());
        quotationDo.setQuotationRound(bargainingDo.getQuoteCurrentRound());
        quotationDo.setTotalOriginalPrice(bargainingDo.getTotalPrice());
        quotationDo.setQuotationStatus("0");
        quotationDo.setCreateOperId(Long.valueOf(bargainingDo.getBargainingOperId()));
        quotationDo.setCreateOperName(bargainingDo.getBargainingOperName());
        UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingId(bargainingDo.getBargainingId());
        ArrayList<UocBargainingQuotationItem> bargainingQuotationItems = new ArrayList<UocBargainingQuotationItem>();
        for (UocBargainingItem uocBargainingItem : bargainingDo.getBargainingItems()) {
            UocBargainingQuotationItem quotationItem = new UocBargainingQuotationItem();
            quotationItem.setQuotationItemId(IdUtil.nextId());
            quotationItem.setQuotationId(quotationDo.getQuotationId());
            quotationItem.setBargainingItemId(uocBargainingItem.getBargainingItemId());
            quotationItem.setSkuId(uocBargainingItem.getSkuId());
            bargainingQuotationItems.add(quotationItem);
        }
        quotationDo.setBargainingQuotationItems(bargainingQuotationItems);
        this.uocBargainingModel.createQuotation(quotationDo);
    }
}

