/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.service.bargaining.UocQryBargainingDetailService;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocQryBargainingDetailService"})
public class UocQryBargainingDetailServiceImpl
implements UocQryBargainingDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocQryBargainingDetailServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"qryBargainingDetail"})
    public UocQryBargainingDetailRspBo qryBargainingDetail(@RequestBody UocQryBargainingDetailReqBo reqBo) {
        this.verifyParam(reqBo);
        UocBargainingDo qryDo = UocRu.js(reqBo, UocBargainingDo.class);
        UocBargainingDo uocBargainingDo = this.uocBargainingModel.qryBargainingBy(qryDo);
        UocQryBargainingDetailRspBo rspBo = UocRu.js(uocBargainingDo, UocQryBargainingDetailRspBo.class);
        UocBargaining bargaining = new UocBargaining();
        bargaining.setBargainingId(uocBargainingDo.getBargainingId());
        bargaining.setAddressId(uocBargainingDo.getAddressId());
        UocBargainingAddressBo addressBo = this.uocBargainingModel.getModelBy(bargaining);
        rspBo.setBargainingAddress(addressBo);
        return rspBo;
    }

    private void verifyParam(UocQryBargainingDetailReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getBargainingId()) {
            throw new BaseBusinessException("102001", "\u8bae\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

