package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocNumChngOrderCreateServiceImpl
 * 说明:数量变更申请
 * 时间:2022/3/8 18:02
 * 作者:罗有
 */
@HTServiceImpl
public class UocNumChngOrderCreateForInspServiceImpl implements UocNumChngOrderCreateForInspService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    private static final Integer CHNG_TYPE_ADD = 1;

    private static final Integer CHNG_TYPE_SUBTRACT = 2;
    @Override
    public UocNumChngOrderCreateForInspRspBo createNumChng(UocNumChngOrderCreateForInspReqBo reqBo) {
        validateArg(reqBo);
        String operId = String.valueOf(reqBo.getUserId());
        Date now = new Date();
        List<UocInspOrderItem> inspOrderItemList = getInspOrderItemList(reqBo);
        checkChngingCount(reqBo, inspOrderItemList);
        List<UocSaleOrderItem> saleOrderItems = getImplOrderItemList(inspOrderItemList);
        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo, operId, now, inspOrderItemList, saleOrderItems);
        iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            iUocInspOrderModel.modifyInspOrderItemChngingCount(convertInspOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, operId, now));
            iUocSaleOrderModel.modifyBatchItemChngingCount(convertImplOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, inspOrderItemList, operId, now));
        }
        UocNumChngOrderCreateForInspRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateForInspRspBo.class);
        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocNumChngOrderCreateRspBo.setInspOrderIdList(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateReqInspBo::getInspOrderId).collect(Collectors.toList()));
        uocNumChngOrderCreateRspBo.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        return uocNumChngOrderCreateRspBo;
    }

    /**
     * 检查执行单下是否已有在途异常变更
     *
     * @param reqBo
     * @param inspOrderItemList
     */
    private void checkChngingCount(UocNumChngOrderCreateForInspReqBo reqBo, List<UocInspOrderItem> inspOrderItemList) {
        Map<Long, UocInspOrderItem> uocInspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        reqBo.getChngItemList().forEach(x -> {
            x.getInspOrderItemList().forEach(y -> {
                //UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
                //uocChngOrderItemObjQryBo.setInspOrderItemId(y.getInspOrderItemId());
                //uocChngOrderItemObjQryBo.setChngType(UocConstant.BUSI_TYPE.NUM);
                //List<UocChngOrderItemObj> listChngOrderItemObj = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
                //BigDecimal chngCount = BigDecimal.ZERO;
                //if (CollectionUtil.isNotEmpty(listChngOrderItemObj)) {
                //    chngCount = listChngOrderItemObj.stream().map(UocChngOrderItemObj::getChngNum).reduce((x1, x2) -> x1.add(x2)).get();
                //}
                UocInspOrderItem uocInspOrderItem = uocInspOrderItemMap.get(y.getInspOrderItemId());
                if (uocInspOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "存在异常变更在途数量，请待变更完结后再发起");
                }
                Integer addOrDelType = y.getAddOrDelType();
                if (addOrDelType == 1){
                    //增减类型为‘增加验收数量’时：调整数量范围为0~（初始验收数量-剩余验收量）
                    if (!(y.getChngCount().compareTo(BigDecimal.ZERO) >= 0
                    && y.getChngCount().compareTo(uocInspOrderItem.getInitInspCount().subtract(uocInspOrderItem.getRemainInspCount()))<= 0)) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "变更数量超过(初始验收数量-剩余验收量)范围，请重新填写");
                    }
                } else if (addOrDelType == 2){
                    //增减类型为‘减少验收数量’时：调整数量的范围为0~剩余验收量；
                    if (!(y.getChngCount().compareTo(BigDecimal.ZERO) >= 0
                            && y.getChngCount().compareTo(uocInspOrderItem.getRemainInspCount())<= 0)) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "变更数量超过剩余验收量范围，请重新填写");
                    }
                }
            });
        });
    }

    /**
     * 组装销售单信息
     */
    private UocSaleOrderDo convertImplOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo, List<UocInspOrderItem> inspOrderItemList, String operId, Date now) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(operId);
        Map<Long, UocInspOrderItem> uocInspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> uocImplOrderItemMap = new HashMap<>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
            UocInspOrderItem uocInspOrderItem = uocInspOrderItemMap.get(x.getInspOrderItemId());
            UocSaleOrderItem uocSaleOrderItem = uocImplOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if (null == uocSaleOrderItem) {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setChngingCount(x.getChngCount());
            } else {
                uocSaleOrderItem.setChngingCount(uocSaleOrderItem.getChngingCount().add(x.getChngCount()));
            }
            uocImplOrderItemMap.put(uocInspOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        });

        uocSaleOrderDo.setSaleOrderItems(new ArrayList<>(uocImplOrderItemMap.values()));
        return uocSaleOrderDo;
    }

    /**
     * 组装发货单信息
     */
    private UocInspOrderDo convertInspOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo, String operId, Date now) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
        uocInspOrderDo.setUpdateOperId(operId);
        uocInspOrderDo.setUpdateTime(now);
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setInspOrderItemId(x.getInspOrderItemId());
            uocInspOrderItem.setChngingCount(x.getChngCount());
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }

    /**
     * 转换变更单do
     */
    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, String operId, Date now, List<UocInspOrderItem> inspOrderItemList, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> implOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QRZ);
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(reqBo));
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObj.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderObj.setCreateOperId(operId);
            uocChngOrderObj.setCreateTime(now);
            List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
            uocChngOrderObj.setChngNum(BigDecimal.ZERO);
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);
            uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
                UocInspOrderItem uocInspOrderItem = inspOrderItemMap.get(x.getInspOrderItemId());
                UocSaleOrderItem saleOrderItem = implOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setChngNum(x.getChngCount());
                uocChngOrderItemObj.setChngFee(x.getChngCount().multiply(saleOrderItem.getSalePrice()));
                uocChngOrderItemObj.setChngPurchaseFee(x.getChngCount().multiply(saleOrderItem.getPurchasePrice()));
                uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setInspOrderItemId(x.getInspOrderItemId());
                uocChngOrderItemObj.setImplOrderItemId(uocInspOrderItem.getImplOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setCreateOperId(operId);
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObj.setAddOrSubtractType(x.getAddOrDelType());
                uocChngOrderItemObj.setRemainInspCount(x.getRemainInspNum());
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
                uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(x.getChngCount()));
                if (x.getAddOrDelType().equals(CHNG_TYPE_ADD)){
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().subtract(uocChngOrderItemObj.getChngFee()));
                } else if (x.getAddOrDelType().equals(CHNG_TYPE_SUBTRACT)){
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().add(uocChngOrderItemObj.getChngFee()));
                }
            });
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        }

        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }

        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateForInspReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询销售单为空");
        }

        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    /**
     * 获取发货单明细数据
     */
    private List<UocInspOrderItem> getInspOrderItemList(UocNumChngOrderCreateForInspReqBo reqBo) {
        List<UocInspOrderItem> inspOrderItems = new ArrayList<>();
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setInspOrderItemIdList(uocNumChngOrderCreateReqInspBo.getInspOrderItemList().stream().map(UocNumChngOrderCreateReqInspItemBo::getInspOrderItemId).collect(Collectors.toList()));
            uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocInspOrderItemQryBo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
            UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询发货单明细列表为空");
            }
            inspOrderItems.addAll(uocInspOrderDo.getUocInspOrderItemList());
        }

        return inspOrderItems;
    }

    /**
     * 获取销售单明细
     */
    private List<UocSaleOrderItem> getImplOrderItemList(List<UocInspOrderItem> uocInspOrderItemList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderItemList.get(0).getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(uocInspOrderItemList.stream().map(UocInspOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);

        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询销售单明细列表为空");
        }
        return saleOrderItemList;
    }

    private void validateArg(UocNumChngOrderCreateForInspReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表为空");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqInspBo -> {
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收单ID为空");
            }
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderItemList()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收对象为空");
            }
            uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
                if (null == x.getInspOrderItemId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收单明细ID为空");
                }
                if (null == x.getChngCount()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更数量为空");
                }
                if (null == x.getAddOrDelType()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更类型为空");
                }
                if (null == x.getRemainInspNum()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参剩余验收数量为空");
                }
                if (1 != x.getAddOrDelType() && 2 != x.getAddOrDelType()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更类型错误");
                }
            });
        });

    }
}

