package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpItemMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderMap;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceReqItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocCreateOrderServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 14:40
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocCreateCmpOrderServiceImpl implements UocCreateCmpOrderService{
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Override
    public UocCreateCmpOrderServiceRspBo createCmpOrder(UocCreateCmpOrderServiceReqBo reqBo) {
        UocCreateCmpOrderServiceRspBo rspBo = UocRu.success(UocCreateCmpOrderServiceRspBo.class);
        validateArg(reqBo);
        UocCmpOrderDo uocCmpOrderDo = buildDoByBO(reqBo);
        uocCmpOrderModel.createCmpOrder(uocCmpOrderDo);
        rspBo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
        return rspBo;
    }

    private UocCmpOrderDo buildDoByBO(UocCreateCmpOrderServiceReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setCreateOperName(reqBo.getUsername());
        reqBo.setCreateOperId(reqBo.getWorkNo());
        reqBo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
        reqBo.setCreateOrgName(reqBo.getOrgName());
        UocCmpOrderDo cmpOrderDo = UocRu.js(reqBo, UocCmpOrderDo.class);
        for (UocCreateCmpOrderServiceReqItemBo uocCreateCmpOrderServiceReqItemBo : reqBo.getUocCmpOrderItemList()) {
            uocCreateCmpOrderServiceReqItemBo.setCreateTime(new Date());
        }
        List<UocCmpOrderItem> items = UocRu.jsl(reqBo.getUocCmpOrderItemList(), UocCmpOrderItem.class);
        if(!CollectionUtil.isEmpty(items)){
            Map<String, List<UocBaseExtParallelBo>> skuMap =
                    reqBo.getUocCmpOrderItemList().stream().collect(Collectors.toMap(UocCreateCmpOrderServiceReqItemBo::getSkuId, UocCreateCmpOrderServiceReqItemBo::getItemParallelExtList));
            for (UocCmpOrderItem item : items) {
                List<UocBaseExtParallelBo> uocBaseExtParallelBos = skuMap.get(item.getSkuId());
                List<UocCmpItemMap> uocCmpItemMapList = UocRu.jsl(uocBaseExtParallelBos, UocCmpItemMap.class);
                item.setUocCmpItemMapList(uocCmpItemMapList);
            }
        }
        cmpOrderDo.setUocCmpOrderItemList(items);
        if(!CollectionUtil.isEmpty(reqBo.getParallelExtList())){
            cmpOrderDo.setUocCmpOrderMapList(UocRu.jsl(reqBo.getParallelExtList(), UocCmpOrderMap.class));
        }
        return cmpOrderDo;
    }

    private void validateArg(UocCreateCmpOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateCmpOrderServiceReqBo]不能为空");
        }
        if (CollectionUtil.isEmpty(reqBo.getUocCmpOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[uocCmpOrderItemList]不能为空");
        }
        for (UocCreateCmpOrderServiceReqItemBo uocCreateCmpOrderServiceReqItemBo : reqBo.getUocCmpOrderItemList()) {
            if(StringUtils.isBlank(uocCreateCmpOrderServiceReqItemBo.getSkuId())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参商品明细的skuId不能为空");
            }
        }
    }
}
