package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocItPlatformInspItemBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 创建验收单（用户接收IT验收信息）
 * @Date 14:15 2023/8/18
 * @Param 
 * @return 
 */
@Slf4j
@HTServiceImpl
public class UocCreateInspOrderServiceImpl implements UocCreateInspOrderService{
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    
    /**
     * 全部验收完成
     */
    private static final String OP_FLAG_YES = "1";
    /**
     * 未全部验收完成
     */
    private static final String OP_FLAG_NO = "0";
    /**
     * 订单来源-电商
     */
    private static final String EC_IMPORT = "2";
    /**
     * 全部-供应商ID
     */
    private static final String SUP_NO = "0";
    
    
    @Override
    public UocCreateInspOrderServiceRspBo createInspOrder(UocCreateInspOrderServiceReqBo reqBo) {
    
        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo, reqBo.getInspItemList().stream().map(UocItPlatformInspItemBO::getSaleOrderItemId).distinct().collect(Collectors.toList()));
    
    
        //更新销售单信息
        this.updateSaleOrderInfo(reqBo,saleOrderItemInfos);
        //创建验收单
        Long inspOrderId = this.createInspOrder(reqBo,saleOrderItemInfos);
        //创建订单结算关联数据
        this.createOrderSettleRelInfo(reqBo,inspOrderId);
    
        //更新销售单的状态
        this.updateSaleOrderState(reqBo,saleOrderItemInfos);
        //提交销售单任务
        this.submitSaleOrderTask(reqBo);
        
        return null;
    }
    
    
    /**
     * 提交销售单任务
     * @param reqBo
     */
    private void submitSaleOrderTask(UocCreateInspOrderServiceReqBo reqBo){
    
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setObjId(reqBo.getSaleOrderId());
        taskInst.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        List<UocOrderTaskInst> taskInstList = iUocSaleOrderModel.qryTaskInstList(taskInst);
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(taskInstList.get(0).getTaskInstId());
        taskBo.setStepId(taskInstList.get(0).getProcState());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(taskInstList.get(0).getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }
    
    /**
     * 更新销售单状态，如发货单存在拒收或者有部分验收则销售单为部分验收，全部验收为已验收
     */
    private void updateSaleOrderState(UocCreateInspOrderServiceReqBo reqBo,List<UocSaleOrderItem> saleOrderItemInfos) {
       
        //组装需要更新的销售单信息
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        //设置订单id
        updateSaleOrderDo.setOrderId(saleOrderItemInfos.get(0).getOrderId());
        //设置销售单id
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置更新人id
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        //设置更新时间
        updateSaleOrderDo.setUpdateTime(new Date());
        //设置更新人名称
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        //设置销售单的状态
        BigDecimal purchaseCount  = new BigDecimal("0");
        BigDecimal acceptanceCount  = new BigDecimal("0");
        for (UocSaleOrderItem uocSaleOrderItem: saleOrderItemInfos){
            purchaseCount = purchaseCount.add(uocSaleOrderItem.getPurchaseCount());
            acceptanceCount = acceptanceCount.add(uocSaleOrderItem.getAcceptanceCount());
    
        }
        BigDecimal outInspCount  = new BigDecimal("0");
        for (UocItPlatformInspItemBO each: reqBo.getInspItemList()){
            outInspCount = outInspCount.add(each.getInspCount());
        }
        if((purchaseCount.add(acceptanceCount)).compareTo(outInspCount) == 1){
            updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_BFYS);
        }else if((purchaseCount.add(acceptanceCount)).compareTo(outInspCount) == 0){
            updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_YS);
        }
        if (StringUtils.isNotEmpty(updateSaleOrderDo.getSaleOrderState())){
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }
    
    
    /**
     * 创建订单结算关联数据
     * @param reqBo
     * @param inspOrderId
     */
    private void createOrderSettleRelInfo(UocCreateInspOrderServiceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if(null != saleOrderMain){
            //生产服务费结算关联数据
            this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
                //贸易模式：
                //生成普通开票关联数据
                this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
                //生成上游开票关联数据
                this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            }else if(UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) {
                //撮合模式：
                //生成下游撮合开票关联数据
                this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
            } else {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生产订单结算关联数据失败：错误的结算模式");
            }
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生产订单结算关联数据失败：查询销售单单为空");
        }
    }
    
    /**
     * 生成外部关联数据
     * @param
     * @param inspOrderId
     * @param relType
     */
    private void createRelInfo(Long orderId, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        //设置数据id
        createOrderRel.setId(IdUtil.nextId());
        //设置关联状态
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        //设置关联类型
        createOrderRel.setRelType(relType);
        //设置订单ID
        createOrderRel.setOrderId(orderId);
        //设置关联对象id
        createOrderRel.setObjId(inspOrderId);
        //设置关联对象类型
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }
    
    
    /**
     * 更新销售单信息
     * @param reqBo
     * @param
     */
    private void updateSaleOrderInfo(UocCreateInspOrderServiceReqBo reqBo,List<UocSaleOrderItem> saleOrderItemInfos){
        //将发货单明细转化为map
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        //设置订单id
        updateSaleOrderDo.setOrderId(saleOrderItemInfos.get(0).getOrderId());
        //设置销售单id
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置更新人id
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        //设置更新人名称
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        //设置更新时间
        updateSaleOrderDo.setUpdateTime(new Date());
        //组装需要更新的销售单明细
        Map<Long, UocSaleOrderItem> saleItemIdMap = new HashMap<>();
       Map<Long,UocItPlatformInspItemBO> inspItemBOMap = reqBo.getInspItemList().stream().collect(Collectors.toMap(UocItPlatformInspItemBO::getSaleOrderItemId,e->e));
        saleOrderItemInfos.forEach(uocSaleOrderItem ->{
            uocSaleOrderItem.setAcceptanceCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        });
        
        //设置销售单明细
        updateSaleOrderDo.setSaleOrderItems(new ArrayList<>(saleItemIdMap.values()));
        //更新销售单明细验收数量和超验数量
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
        
        // 更新销售单明细超验标识
        this.iUocSaleOrderModel.modifyInspSuper(updateSaleOrderDo);
      
    }
    
    /**
     * 查询发货单明细对应的销售单明细
     * @param reqBo
     * @param saleOrderItemIdList
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocCreateInspOrderServiceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置销售单明细id集合
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        //设置销售单id
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
        }
    }
    /**
     * 获取验收单编号
     */
    private String getInspOrderNo(UocCreateInspOrderServiceReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if(null != saleOrderMain){
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if(null != inspOrderNo){
                return inspOrderNo.getInspOrderNo();
            }else{
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生成验收单编号失败");
            }
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生成验收单编号失败，查询销售单数据为空");
        }
    }
    
    private Long createInspOrder(UocCreateInspOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItems){
       
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        //组装验收单数据
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        //生产验收单id
        Long inspOrderId = IdUtil.nextId();
        //设置订单id
        createInspOrderDo.setOrderId(saleOrderItems.get(0).getOrderId());
        //设置销售单id
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置验收单id
        createInspOrderDo.setInspOrderId(inspOrderId);
//        //设置备注
//        createInspOrderDo.setRemark(reqBo.getRemark());
//        //设置其他备注
//        createInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        //设置验收单编号
        createInspOrderDo.setInspOrderNo(getInspOrderNo(reqBo));
        //设置验收单状态
        createInspOrderDo.setInspOrderState(UocStateConstants.InspOrder.YS_YS_YS);
        //设置验收人名称
        createInspOrderDo.setInspOper(reqBo.getName());
        //设置创建人id
        createInspOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        //设置创建时间
        createInspOrderDo.setCreateTime(new Date());
        //设置开票标识
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        //设置验收人电话
        createInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        //设置租户ID
        createInspOrderDo.setTenantId(reqBo.getTenantId());
        //设置采购金额
//        createInspOrderDo.setTotalPurchaseFee(BigDecimal.ZERO);
        //设置销售金额
//        createInspOrderDo.setTotalSaleFee(BigDecimal.ZERO);
        //定义需要创建的发货验收关系集合
        List<UocShipInspRel> uocShipInspRelList = new ArrayList<>();
        //定义需要创建的验收明细集合
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        
        //组装发货验收关系
        Map<Long,UocItPlatformInspItemBO> inspItemBOMap = reqBo.getInspItemList().stream().collect(Collectors.toMap(UocItPlatformInspItemBO::getSaleOrderItemId,e->e));
    
        
        saleOrderItems.forEach(uocSaleOrderItem -> {
                UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
                //设置订单id
                createInspOrderItem.setOrderId(uocSaleOrderItem.getOrderId());
                //设置销售单id
                createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                //设置验收单id
                createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
                //设置验收单明细id
                createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                //设置验收数量
                createInspOrderItem.setInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
                //设置剩余验收数量
                createInspOrderItem.setRemainInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
                //设置初始验收数量
                createInspOrderItem.setInitInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
                //设置销售单明细id
                createInspOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
                //设置计量单位
                createInspOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
                //设置创建时间
                createInspOrderItem.setCreateTime(new Date());
                //设置创建人id
                createInspOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
                uocInspOrderItemList.add(createInspOrderItem);
           
        });
        //设置验收发货关系
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        //设置验收明细
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        //设置允许变更时限
        createInspOrderDo.setAllowChngTime(this.getInspAllowChngTime(reqBo,saleOrderItems.get(0).getOrderId()));
        
        
        //组装附件信息
        List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())){
            reqBo.getOrderAccessoryBoList().forEach(obj->{
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(saleOrderItems.get(0).getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        
        //计算验收销售/采购金额
        BigDecimal inspSaleMoney = BigDecimal.ZERO;
        BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
        for (UocInspOrderItem uocInspOrderItem: uocInspOrderItemList){
            
            UocSaleOrderItem saleOrderItem = uocSaleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if(null != saleOrderItem.getSalePrice() && null != saleOrderItem.getPurchaseCount()){
                BigDecimal inspSalFee = saleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                inspSaleMoney = inspSaleMoney.add(inspSalFee);
            }
            if(null != saleOrderItem.getPurchasePrice() && null != saleOrderItem.getPurchaseCount()){
                BigDecimal purSalFee = saleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
                
                inspPurchaseMoney = inspPurchaseMoney.add(purSalFee);
            }
        }
        createInspOrderDo.setTotalSaleFee(inspSaleMoney);
        createInspOrderDo.setTotalPurchaseFee(inspPurchaseMoney);
        //创建验收单
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);
        
        return inspOrderId;
    }
    
    
    /**
     * 获取验收单时效配置
     *
     * @param reqBo
     */
    private Date getInspAllowChngTime(UocCreateInspOrderServiceReqBo reqBo,Long orderId) {
        //查询销售单
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        //查询时效类配置
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode(UocConstant.EffectiveCode.TIME_LIMIT_FOR_ABNORMAL_ORDER_CHANGES);
        List<UocConfEffective> rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        
        if (ObjectUtil.isNotEmpty(rows)) {
            //将时效配置转化为map
            Map<String, UocConfEffective> confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            //找到对应配置的时效配置
            if(null != saleOrderMain){
                String key = null;
                if(null != saleOrderMain.getStakeholder()){
                    key = saleOrderMain.getOrderSource() + saleOrderMain.getStakeholder().getSupId();
                }else{
                    key = String.valueOf(saleOrderMain.getOrderSource()) + reqBo.getSupId();
                }
                if (ObjectUtil.isNotNull(confEffectiveMap.get(key))){
                    allowChngTime = new Date(confEffectiveMap.get(key).getAging());
                }else {
                    allowChngTime = new Date(confEffectiveMap.get(saleOrderMain.getOrderSource() + SUP_NO).getAging());
                }
            }else{
                allowChngTime = new Date(confEffectiveMap.get(EC_IMPORT + SUP_NO).getAging());
            }
        }
        
        return allowChngTime;
    }
    
}
