package com.tydic.dyc.oc.model.bargaining;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.*;

import java.util.List;

/**
 * 标题:IUocBargainingModel
 * 说明:
 * 时间:2023/7/26 15:18
 * 作者:Dum
 */
public interface IUocBargainingModel {
    /**
     * 查议价单列表
     *
     * @param uocBargainingQryBo
     * @return
     */
    List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo);
    /**
     * 新增议价单列表
     *
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 议价单父单列表
     *
     * @param uocBargainingParentDo
     * @return
     */
    UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo);

    /**
     * 查议价单列表（精准筛查）
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 更改议价单状态
     * @param uocBargainingDo
     * @return
     */
    void updateBargaining(UocBargainingDo uocBargainingDo);
    /**
     * 描述:查询议价单信息
     * @param uocBargainingDo
     * @return
     */
    UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo);

    /**
     * 描述:查询议价单明细信息
     * @param uocBargainingItemQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem></>
     * @return
     */
    List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo);
    /**
     * 查询，商品维度查询
     *
     * @param uocBargainingItemQryBo
     * @return
     */
    BasePageRspBo<UocBargainingItem> getListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo);


    /**
     * 根据条件查询列表数据
     *
     * @param reqBo 参数对象
     * @return List<UocBargainingProgressRecordPO> 结果对象
     */
    List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo);


    /**
     * 根据条件查询单条数据
     *
     * @param reqBo  参数对象
     * @return UocBargainingAddressBo 结果对象
     */
    UocBargainingAddressBo getModelBy(UocBargaining reqBo);

    /**
     * 议价单-报价记录查询服务
     *
     * @param reqBo  参数对象
     * @return UocBargainingAddressBo 结果对象
     */
    List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo);


    UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo);

    /**
     * 发起报价单初始化
     * @param uocBargainingQuotationDo
     * @return
     */
    UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo);

    /**
     * 更改报价单状态
     * @param uocBargainingQuotationDo
     * @return
     */
    void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo);
    /**
     * 更改报价单明细
     * @param uocBargainingQuotationDo
     * @return
     */
    void updateQuotationItemWithSkuId(UocBargainingQuotationDo uocBargainingQuotationDo);
    /**
     * 报价单查询
     * @param uocBargainingQuotationBo
     * @return
     */
    public UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo);

    /**
     * 新增议价单列表
     * @param uocBargainingProgressRecordDo
     * @return
     */
    void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo);
}
