package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerShipArrivaRegist
 * 说明:发货单 到货登记
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j

public class EventConsumerShipArrivaRegist implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerShipArrivaRegist->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Object shipOrderIdObj = map.get("shipOrderIdList");
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        List<Long> shipOrderIdList = UocRu.castList(shipOrderIdObj, Long.class);
        List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
        shipOrderIdList.forEach(shipOrderId -> {
            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
            syncQryReqBo.setOrderId(orderId);
            syncQryReqBo.setObjId(shipOrderId);
            shipList.add(syncQryReqBo);
        });
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getShipOrderIndex());
        eventReqBo.setDataList(shipList);
        retList.add(eventReqBo);

        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);
        saleList.add(sale);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleEventReqBo.setDataList(saleList);
        retList.add(saleEventReqBo);

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_SHIP_ARRIVA_REGIST;
    }

}


