package com.tydic.dyc.oc.components.ordSourceProcessor;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 标题:UocOrderSourceProcessorManager
 * 说明: 不同订单来源处理类 管理类
 * 时间:2022/4/6 15:00
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocOrderSourceProcessorManager {

    /**
     * 在系统启动时，缓存数据查询实现类
     */
    private final Map<Integer, UocOrderSourceProcessor> manageMap = new ConcurrentHashMap<>();


    /**
     * 描述:注册实现类
     *
     * @param intObj 入参
     * @return void
     * @author tgy
     * @date 2022/3/1 12:50
     */
    public void register(UocOrderSourceProcessor intObj) {
        Integer skuSource = intObj.skuSource();

        Assert.notNull(intObj, "intObj can not be null");
        Assert.notNull(skuSource, "skuSource can not be null");

        //此处获取到得必须为空，不为空则为重复
        UocOrderSourceProcessor intRet = manageMap.get(skuSource);
        if (intRet != null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "不同订单来源实现类(" + skuSource + ")出现多个实现类！");
        }
        log.info(UocOrderSourceProcessorManager.class.getSimpleName() + ".register注册了订单来源实现类：" + skuSource);

        manageMap.put(skuSource, intObj);
    }

    public UocOrderSourceProcessor getInstance(Integer skuSource) {
        //此处获取到得必须为空，不为空则为重复
        UocOrderSourceProcessor intRet = manageMap.get(skuSource);
        if (intRet == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "订单来源实现类(" + skuSource + ")不存在！");
        }
        return intRet;
    }


}


