package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 审批单同步es
 * @Date 16:12 2023/8/1
 * @Param 
 * @return 
 */
@Slf4j
@Service
public class UocEsSyncApprovalPlus implements IUocEsSync {

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return uocIndexConfig.getApprovalOrderPlusIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        //获取审批单id
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        //查询审批单信息
        UocAuditOrderDo uocAuditOrderDo = getUocAuditOrderDo(reqBo);
        if (null == uocAuditOrderDo) {
            return iUocEsSyncQryRspBo;
        }
        //查询字典
        Map<String, Map<String, String>> dicMap = getDic();
        //查询审批对象表（审批单关系表）
        List<UocApprovalObj> uocApprovalObjList = getAuditOrderObjList(reqBo);
        JSONObject auditOrderJson = JSON.parseObject(JSON.toJSONString(uocAuditOrderDo, SerializerFeature.WriteMapNullValue));
        if (!CollectionUtils.isEmpty(uocApprovalObjList)) {
            for(UocApprovalObj uocApprovalObj: uocApprovalObjList){
                if(UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObj.getObjType())) {
                    //查询销售单表
                    UocSaleOrderDo saleOrder = getSaleOrder(uocApprovalObj);
                    if (null != saleOrder) {
                        Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
                        Map<String, String> saleOrderState = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
                        saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                        saleOrder.setPayTypeStr(payType.get(saleOrder.getPayType()));
                        saleOrder.setModelSettleStr(null != saleOrder.getModelSettle() ?
                                dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle() != null ? saleOrder.getModelSettle().toString() : saleOrder.getModelSettle()) : "");
                        //查询销售单明细表
                        List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(uocApprovalObj);
                        saleOrder.setSaleOrderItems(uocSaleOrderItemList);
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_TIME,saleOrder.getCreateTime());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_ID,saleOrder.getCreateOperId());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_NAME,saleOrder.getCreateOperName());
                        
                        //三方
                        UocSaleStakeholder stakeholder = saleOrder.getStakeholder();
                        JSONObject saleJsonObject = JSON.parseObject(JSON.toJSONString(saleOrder));
    
                        saleJsonObject.put(UocConstant.ES_MAIN_OTHER.SUP_ID,stakeholder.getSupId());
                        saleJsonObject.put(UocConstant.ES_MAIN_OTHER.SUP_NAME,stakeholder.getSupName());
                        saleJsonObject.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID,stakeholder.getPurOrgId());
                        saleJsonObject.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME,stakeholder.getPurOrgName());
    
    
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleJsonObject);
                        
    
                    }
                    //查询销售单扩展
                    List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(uocApprovalObj);
                    if (null != saleOrderMapList) {
                        saleOrderMapList.forEach(each -> auditOrderJson.put(each.getFieldCode(), each.getFieldValue()));
                    }
                }
                //查询审批单流程实例
                UocGetSaleOrderDetailServiceRspPorcBo auditBusiProcInst = getProcInst(uocApprovalObj, true,auditOrderJson);
                auditOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, ObjectUtil.isNotEmpty(auditBusiProcInst.getProcInstId()) ? auditBusiProcInst.getProcInstId() : "");
                auditOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, ObjectUtil.isNotEmpty(auditBusiProcInst.getTaskList()) ? auditBusiProcInst.getTaskList() : new ArrayList<>());
    
                //翻译
                translateProperties(auditOrderJson, dicMap);
            }
            
        }

        iUocEsSyncQryRspBo.setJsonObj(auditOrderJson);
        log.info("新审批单同步es入参：{}",JSON.toJSONString(iUocEsSyncQryRspBo));
        return iUocEsSyncQryRspBo;
    }
    
    /**
     * 翻译出参数据
     *
     * @param jsonObj
     */
    private void translateProperties(JSONObject jsonObj, Map<String, Map<String, String>> dictionaryMap) {
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            //预算模式翻译
            if (null != dictionaryMap.get(UocDicConstant.BUDGET_MDEL.P_CODE) && null != jsonObj.get(UocConstant.ES_MAIN_OTHER.BUDGET_MODEL)) {
                jsonObj.put(UocConstant.ES_MAIN_OTHER.BUDGET_MODEL_NAME, dictionaryMap.get(UocDicConstant.BUDGET_MDEL.P_CODE).get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.BUDGET_MODEL)));
            }
            //审批状态翻译
            if (null != dictionaryMap.get(UocDicConstant.AUDIT_STATUS.P_CODE) && null != jsonObj.get(UocConstant.ES_MAIN_OTHER.AUDIT_STATUS)) {
                jsonObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_STATUS_STR, dictionaryMap.get(UocDicConstant.AUDIT_STATUS.P_CODE).get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.AUDIT_STATUS)));
            }
        }
    }
    
    
    /**
     * 查询销售单扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap
     */
    private List<UocSaleOrderMap> getSaleOrderMapList(UocApprovalObj reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(Convert.toLong(reqBo.getObjId()));
        
        return iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }
    
    
    private UocAuditOrderDo getUocAuditOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
        uocAuditOrderQryBo.setAuditOrderId(reqBo.getObjId());
        uocAuditOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
    }

    /**
     * 协议单列表查询
     *
     * @param saleOrder
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrder.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrder.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
    }

    private List<UocApprovalObj> getAuditOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getObjId());
        return iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocApprovalObj uocApprovalObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(Convert.toLong(uocApprovalObj.getObjId()));
        uocSaleOrderQryBo.setOrderId(uocApprovalObj.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocApprovalObj uocApprovalObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(Convert.toLong(uocApprovalObj.getObjId()));
        uocSaleOrderItemQryBo.setOrderId(uocApprovalObj.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        pCodes.add(UocConstant.AUDIT_TYPE.P_CODE);
        pCodes.add(UocDicConstant.AUDIT_STATUS.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    /**
     * 查询流程任务实例
     *
     * @param uocApprovalObj
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocApprovalObj uocApprovalObj, Boolean isAudit,JSONObject auditOrderJson) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjType(uocApprovalObj.getObjType());
        }
        procInstQryBo.setObjId(Convert.toLong(uocApprovalObj.getAuditOrderId()));
        procInstQryBo.setOrderId(uocApprovalObj.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            Map<Integer,List<UocOrderTaskInst>>  taskIntsMap =  uocOrderTaskInsts.stream().collect(Collectors.groupingBy(UocOrderTaskInst::getFinishTag));
    
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(taskIntsMap.get(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED))) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

}
