package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingAddressBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述：议价单详情查询服务
 * @author gaoqh646
 *
 * @date 2023/8/7
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocQryBargainingDetailServiceImpl implements UocQryBargainingDetailService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryBargainingDetailRspBo qryBargainingDetail(UocQryBargainingDetailReqBo reqBo) {
        verifyParam(reqBo);
        UocBargainingDo qryDo=UocRu.js(reqBo, UocBargainingDo.class);

        UocBargainingDo uocBargainingDo = uocBargainingModel.qryBargainingBy(qryDo);
        UocQryBargainingDetailRspBo rspBo = UocRu.js(uocBargainingDo, UocQryBargainingDetailRspBo.class);
        UocBargaining bargaining = new UocBargaining();
        bargaining.setBargainingId(uocBargainingDo.getBargainingId());
        bargaining.setAddressId(uocBargainingDo.getAddressId());
        UocBargainingAddressBo addressBo = uocBargainingModel.getModelBy(bargaining);
        rspBo.setBargainingAddress(addressBo);
        rspBo.setTaskId(getTaskInstId(reqBo));
        return rspBo;


    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocQryBargainingDetailReqBo reqBo) {
        if(null == reqBo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBo.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单ID不能为空");
        }

    }
    /**
     * 查询任务ID
     * 用途：用于议价单流程变更状态
     * @param reqBo
     */
    private String getTaskInstId(UocQryBargainingDetailReqBo reqBo) {
        String taskId ="";
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getBargainingId());
        taskInstQryBo.setObjId(reqBo.getBargainingId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
            log.info("议价流程流程数据：{}", JSON.toJSONString(taskInsts));
            if (ObjectUtil.isNotEmpty(taskInsts)) {
                taskId = taskInsts.get(0).getTaskInstId();
            }
        }
        return taskId;
    }
}
