package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 描述：更新状态已下单处理服务实现
 * @author DUM
 * @date 2023/8/17 15:29
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocUpdateBargainingOrderedServiceImpl implements UocUpdateBargainingOrderedService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocUpdateBargainingOrderedRspBo updateBargaining(UocUpdateBargainingOrderedReqBo reqBo) {
        //1 参数校验
        this.verifyParam(reqBo);
        //2 前置状态校验
        this.verifyState(reqBo);
        //2 .修改状态"已下单"
        this.updateBargainingState(reqBo);
        //3. 记录操作记录
        insertProgressRecord(reqBo);
        //4. 返回结果
        return UocRu.success(UocUpdateBargainingOrderedRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyState(UocUpdateBargainingOrderedReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if(!UocStateConstants.BARGAINING_STATES.YJ_YBJ.equals(bargainingDo.getBargainingState())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "只能对已报价的议价单下单！");
        }
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocUpdateBargainingOrderedReqBo reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单id不能为空");
        }
    }
    /**
     * 更新议价单单状态
     * @param reqBO
     */
    private void updateBargainingState(UocUpdateBargainingOrderedReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YXD);
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.updateBargaining(uocBargainingDo);
    }
    /**
     * 记录操作动作
     * @param reqBO
     */
    private void insertProgressRecord(UocUpdateBargainingOrderedReqBo reqBO){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.ORDER);
        recordDo.setOperTypeName("下单成功");
        recordDo.setOperId(Long.valueOf(reqBO.getUserId()));
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        uocBargainingModel.insertProgressRecord(recordDo);
    }
}
