package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspStakeholderBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@HTServiceImpl
public class UocGetApprovalOrderDetailServiceImpl implements UocGetApprovalOrderDetailService{
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    /**
     * 审批单详情查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocGetApprovalOrderDetailServiceRspBo getApprovalOrderDetail(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        
        //入参校验
        this.validateParam(reqBo);
        
        UocGetApprovalOrderDetailServiceRspBo rspBo = UocRu.success(UocGetApprovalOrderDetailServiceRspBo.class);
        //1 . 查询该审批单下得所有销售单id
        //查询审批单，订单id+审批单id+审批对象类型（2：销售单）
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        
        log.info("查询uocApprovalObjs：{}",JSON.toJSONString(uocApprovalObjs));
        //销售单id列表
        List<Long> objIdList = uocApprovalObjs.stream().map(e->{
            return Long.valueOf(e.getObjId());
        }).collect(Collectors.toList());
    
        log.info("查询objIdList：{}",JSON.toJSONString(objIdList));
    
        //查询销售单详情 (只需查询该审批单下得一条销售单信息)
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(objIdList.get(0));
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBo.setCreateOrderTime(saleOrderMainInfo.getCreateTime());
        rspBo.setSendTime(saleOrderMainInfo.getSendTime());
        rspBo.setRemark(saleOrderMainInfo.getRemark());
        
        //组装三方信息
        if (null != saleOrderMainInfo.getStakeholder()) {
            UocGetSaleOrderDetailServiceRspStakeholderBo stakeholderBo = new UocGetSaleOrderDetailServiceRspStakeholderBo();
            BeanUtils.copyProperties(saleOrderMainInfo.getStakeholder(), stakeholderBo);
            rspBo.setStakeholderBo(stakeholderBo);
        }
        
        //查询附件
        //查询所有附件
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderAccessory> accessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            rspBo.setAccessoryList(JSONArray.parseArray(JSON.toJSONString(accessoryList), UocBaseOrderAccessoryTypeDetailBo.class));
        }
        
        //查询主订单信息
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        
        //查询收获人地址信息
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        //设置收获人地址信息
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
    
        //查询销售单主体扩展
        List<UocBaseExtParallelBo> uocBaseExtParallelBoList = new ArrayList<>();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(objIdList.get(0));
    
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            rspBo.setExtFields(JSONArray.parseArray(JSON.toJSONString(saleOrderExpandList), BaseExtendFieldBo.class));
        }
        
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(objIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        log.info("查询审批详情明细：{}",JSON.toJSONString(saleOrderItemList));
    
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            List<UocGetSaleOrderDetailServiceRspItemBo> saleOrderDetailItemBoList = JSONArray.parseArray(JSON.toJSONString(saleOrderItemList)
                    ,UocGetSaleOrderDetailServiceRspItemBo.class);
            rspBo.setSaleOrderDetailItemBoList(saleOrderDetailItemBoList);
            
        }
        log.info("查询审批详情出参：{}",JSON.toJSONString(rspBo));
    
    
        return rspBo;
    }
    
    private void validateParam(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getAuditOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "审批单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}
