/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.UocGetApprovalOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetApprovalOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspStakeholderBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocGetApprovalOrderDetailService"})
public class UocGetApprovalOrderDetailServiceImpl
implements UocGetApprovalOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetApprovalOrderDetailServiceImpl.class);
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"getApprovalOrderDetail"})
    public UocGetApprovalOrderDetailServiceRspBo getApprovalOrderDetail(@RequestBody UocGetApprovalOrderDetailServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetApprovalOrderDetailServiceRspBo rspBo = UocRu.success(UocGetApprovalOrderDetailServiceRspBo.class);
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        log.info("\u67e5\u8be2uocApprovalObjs\uff1a{}", (Object)JSON.toJSONString(uocApprovalObjs));
        List<Long> objIdList = uocApprovalObjs.stream().map(e -> Long.valueOf(e.getObjId())).collect(Collectors.toList());
        log.info("\u67e5\u8be2objIdList\uff1a{}", (Object)JSON.toJSONString(objIdList));
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId((Long)objIdList.get(0));
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBo.setCreateOrderTime(saleOrderMainInfo.getCreateTime());
        rspBo.setSendTime(saleOrderMainInfo.getSendTime());
        rspBo.setRemark(saleOrderMainInfo.getRemark());
        if (null != saleOrderMainInfo.getStakeholder()) {
            UocGetSaleOrderDetailServiceRspStakeholderBo stakeholderBo = new UocGetSaleOrderDetailServiceRspStakeholderBo();
            BeanUtils.copyProperties((Object)saleOrderMainInfo.getStakeholder(), (Object)stakeholderBo);
            rspBo.setStakeholderBo(stakeholderBo);
        }
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderAccessory> accessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            rspBo.setAccessoryList(JSONArray.parseArray((String)JSON.toJSONString(accessoryList), UocBaseOrderAccessoryTypeDetailBo.class));
        }
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        ArrayList uocBaseExtParallelBoList = new ArrayList();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId((Long)objIdList.get(0));
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            rspBo.setExtFields(JSONArray.parseArray((String)JSON.toJSONString(saleOrderExpandList), BaseExtendFieldBo.class));
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderIdList(objIdList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        log.info("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemList));
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            List saleOrderDetailItemBoList = JSONArray.parseArray((String)JSON.toJSONString(saleOrderItemList), UocGetSaleOrderDetailServiceRspItemBo.class);
            rspBo.setSaleOrderDetailItemBoList(saleOrderDetailItemBoList);
        }
        log.info("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void validateParam(UocGetApprovalOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuditOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5ba1\u6279\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

