/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerSyncBargainingTransaction
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerSyncBargainingTransaction.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncBargainingTransaction->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Object uocBargainingListObj = map.get("uocBargainingList");
        Object bargainingIdObj = map.get("bargainingId");
        ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
        if (ObjectUtil.isNotEmpty((Object)uocBargainingListObj)) {
            JSONArray uocBargainingList = JSON.parseArray((String)JSON.toJSONString((Object)uocBargainingListObj));
            if (ObjectUtil.isNotEmpty((Object)uocBargainingList)) {
                for (int i = 0; i < uocBargainingList.size(); ++i) {
                    JSONObject arrayJson = uocBargainingList.getJSONObject(i);
                    Long bargainingId = arrayJson.getLong("bargainingId");
                    if (bargainingId == null) continue;
                    IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                    syncQryReqBo.setOrderId(bargainingId);
                    syncQryReqBo.setObjId(bargainingId);
                    syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
                    syncQryReqBo.setJsonObj(arrayJson);
                    saleList.add(syncQryReqBo);
                }
            }
            if (ObjectUtil.isNotEmpty(saleList)) {
                IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                eventReqBo.setIndexName(this.uocIndexConfig.getBargainingIndex());
                eventReqBo.setDataList(saleList);
                retList.add(eventReqBo);
            }
        } else if (ObjectUtil.isNotEmpty((Object)bargainingIdObj)) {
            Long bargainingId = UocRu.parseLong(bargainingIdObj);
            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
            syncQryReqBo.setOrderId(bargainingId);
            syncQryReqBo.setObjId(bargainingId);
            syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
            saleList.add(syncQryReqBo);
            IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
            eventReqBo.setIndexName(this.uocIndexConfig.getBargainingIndex());
            eventReqBo.setDataList(saleList);
            retList.add(eventReqBo);
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_CREATE_BARGAINING";
    }
}

