package com.tydic.dyc.oc.model.bargaining;

import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author DUM
 * @date 2023/8/11
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocBargainingQuotationDo {
    /**
     * 报价单id
     */
    private Long quotationId;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 报价截止日期
     */
    private Date quotationExpiryTime;
    private Date quotationExpiryTimeStart;
    private Date quotationExpiryTimeEnd;
    /**
     * 报价轮次
     */
    private Integer quotationRound;
    /**
     * 议价前商品总金额
     */
    private BigDecimal totalOriginalPrice;
    /**
     * 报价总金额
     */
    private BigDecimal totalConfirmedPrice;
    /**
     * 节省金额
     */
    private BigDecimal savedPrice;
    /**
     * 报价状态
     0未报价
     1已报价
     2: 多轮报价中
     */
    private String quotationStatus;
    /**
     * 报价人ID
     */
    private Long quotationOperId;
    /**
     * 报价人姓名
     */
    private String quotationOperName;
    /**
     * 报价时间
     */
    private Date quotationTime;
    private Date quotationTimeStart;
    private Date quotationTimeEnd;
    /**
     * 发起人id
     */
    private Long createOperId;
    /**
     * 发起人姓名
     */
    private String createOperName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 未报价原因
     */
    private String quotationReason;
    /**
     * 价格有效期 预留
     */
    private Date validityTime;
    private Date validityTimeStart;
    private Date validityTimeEnd;
    /**
     * 最新有效报价标志
     0 非最新
     1 最新报价
     */
    private String newestFlag;
    /**
     * 采购议价单编号 预留
     */
    private String purQuotationNo;
    /**
     * 议价单明细
     */
    private List<UocBargainingQuotationItem> bargainingQuotationItems;

    /**
     * 商机单号（京东侧）
     */
    private String biddingCode;
    /**
     * 	商机状态
     */
    private String biddingStatus;
    /**
     * 下单截止时间
     */
    private Date orderDeadLine;
}
