package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-销售单详情查询实现〉
 * @author : yuhao
 * @date : 2022/9/13 14:47
 */
@Slf4j
@HTServiceImpl
public class UocGetSaleOrderDetailServiceImpl implements UocGetSaleOrderDetailService {

    protected static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    private static final String LINE = "_";

    /**
     * apollo配置：是否为销售单
     */
    @Value("${uoc.obj_type.isSale:0}")
    private String isSale;
    @Value("${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;
    @Override
    public UocGetSaleOrderDetailServiceRspBo getSaleOrderDetail(UocGetSaleOrderDetailServiceReqBo reqBo) {
        log.info("查询销售单详情");

        //入参校验
        this.validateParam(reqBo);
        //销售单附件
        List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<>();
        //销售单明细
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<>();
        //发货单信息
        List<UocGetSaleOrderDetailServiceRspShipOrderInfoBo> shipOrderInfo = new ArrayList<>();
        //验收单信息
        List<UocGetSaleOrderDetailServiceRspInspOrderInfoBo> inspOrderInfo = new ArrayList<>();

        //查询销售单主体
        UocSaleOrderDo saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo,null);
        String dataAchiveTabSuffix = null;
        if(dataAchiveFlag){
            if (Objects.isNull(saleOrderMainInfo)) {
                dataAchiveTabSuffix = "_"+new SimpleDateFormat("yyyy").format((reqBo.getSaleOrderId() >> 22) + 1420041600000L);
                saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo,dataAchiveTabSuffix);
            }
        }

        if(saleOrderMainInfo==null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单主体信息失败");
        }

//        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
//        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
//        if (Objects.isNull(uocSaleOrderDo)) {
//            return UocRu.success(UocGetSaleOrderDetailServiceRspBo.class);
//        }
        //组装返回结果信息
        UocGetSaleOrderDetailServiceRspBo rspBo = UocRu.js(saleOrderMainInfo, UocGetSaleOrderDetailServiceRspBo.class);
        if (null == rspBo.getTotalTransFee()) {
            //设置运费
            rspBo.setTotalTransFee(BigDecimal.ZERO);
        }

        //组装三方信息
        if (null != saleOrderMainInfo.getStakeholder()) {
            BeanUtils.copyProperties(saleOrderMainInfo.getStakeholder(), rspBo);
            //设置铺货单位id
            rspBo.setDistirbutionId(saleOrderMainInfo.getStakeholder().getSupId());
            //设置铺货单位名称
            rspBo.setDistirbutionName(saleOrderMainInfo.getStakeholder().getSupName());
            //设置铺货单位联系人
            rspBo.setDistirbutionIdContactName(saleOrderMainInfo.getStakeholder().getSupRelaName());
            //设置铺货单位电话
            rspBo.setDistirbutionIdContactMobile(saleOrderMainInfo.getStakeholder().getSupRelaMobile());
            //设置三方信息
            rspBo.setUocGetSaleOrderDetailServiceRspStakeholderBo(UocRu.js(saleOrderMainInfo.getStakeholder(), UocGetSaleOrderDetailServiceRspStakeholderBo.class));
            //设置运营id
            rspBo.setProId(saleOrderMainInfo.getStakeholder().getProId());
            //设置采购id
            rspBo.setPurUserId(saleOrderMainInfo.getStakeholder().getPurUserId());
        }

        //组装支付配置
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderPayConfQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            //过滤出非账期的支付配置
            saleOrderPayConfList = saleOrderPayConfList.stream()
                    .filter(each -> ObjectUtil.notEqual(each.getPayType(), UocDicConstant.PAY_TYPE.PAY_BY_PERIOD)
                            && null != each.getPrePayFee() && null != each.getVerPayFee() && null != each.getPilPayFee() && null != each.getQuaPayFee())
                    .collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
                UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
                DecimalFormat df = new DecimalFormat("0%");
                BigDecimal divide = new BigDecimal(100);
                //设置付款比例
                rspBo.setPayRatio("预付款" + df.format(payConf.getPrePaySup().divide(divide, 2, BigDecimal.ROUND_HALF_UP)) +
                        "-到货款" + df.format(payConf.getVerPaySup().divide(divide, 2, BigDecimal.ROUND_HALF_UP)) +
                        "-验收款" + df.format(payConf.getPilPaySup().divide(divide, 2, BigDecimal.ROUND_HALF_UP)) +
                        "-质保金" + df.format(payConf.getQuaPaySup().divide(divide, 2, BigDecimal.ROUND_HALF_UP)));
            }
        }

        //查询流程数据
        UocGetSaleOrderDetailServiceRspPorcBo procInst = this.getProcInst(saleOrderMainInfo, isSale,dataAchiveTabSuffix);
        //设置流程数据
        rspBo.setProcInst(procInst);
        //查询已完成环节数据
        List<UocGetSaleOrderDetailServiceRspPorcBo> procTacheFinish = this.getProcTacheFinish(saleOrderMainInfo,dataAchiveTabSuffix);
        rspBo.setFinishTacheInfo(procTacheFinish);

        //查询审批流程数据
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(saleOrderMainInfo, UocDicConstant.OBJ_TYPE.SALE,dataAchiveTabSuffix);
        //设置审批流程数据
        rspBo.setAuditProcInst(auditProcInst);

        //查询主订单
        UocOrderDo orderInfo = this.queryOrderInfo(saleOrderMainInfo.getOrderId(),dataAchiveTabSuffix);
        //设置订单编号
        rspBo.setOrderNo(orderInfo.getOrderNo());
        //设置订单时间
        rspBo.setOrderTime(orderInfo.getCreateTime());
        //设置备注
        rspBo.setRemark(orderInfo.getRemark());

        //如果是协议订单，需要查询协议信息
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMainInfo.getOrderSource())) {
            UocGetSaleOrderDetailServiceRspAgreementInfoBo orderAgreement = this.queryOrderAgrInfo(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getAgrDataId(),dataAchiveTabSuffix);
            //设置协议信息
            rspBo.setAgreementInfo(orderAgreement);
        }

        //查询订单核实信息
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.PRICE_CHG));
        uocChngOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocChngOrderDo> listChngOrder = this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
        UocGetSaleOrderDetailServiceRspVerifyInfoBo orderVerifyInfo = new UocGetSaleOrderDetailServiceRspVerifyInfoBo();
        if (ObjectUtil.isNotEmpty(listChngOrder)) {
            //如果有调价信息
            //设置调价人
            orderVerifyInfo.setAdjustName(listChngOrder.get(0).getCreateOperName());
            //设置调价时间
            orderVerifyInfo.setAdjustTime(listChngOrder.get(0).getCreateTime());
            //设置调价备注
            orderVerifyInfo.setRemark(listChngOrder.get(0).getRemark());
        } else {
            //如果没有调价信息
            //设置调价人
            orderVerifyInfo.setAdjustName(saleOrderMainInfo.getAdjustPriceOperName());
            //设置调价时间
            orderVerifyInfo.setAdjustTime(saleOrderMainInfo.getAdjustPriceTime());
        }
        //设置订单核实信息
        rspBo.setOrderVerifyInfo(orderVerifyInfo);


        //查询收获人地址信息
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        relaQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        //设置收获人地址信息
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));


        //查询发票信息
        UocOrdInvoiceQryBo invoiceQryBo = new UocOrdInvoiceQryBo();
        invoiceQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        invoiceQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdInvoice uocOrdInvoice = this.iUocOrderModel.qryOrderInvoice(invoiceQryBo);
        //设置发票信息
        rspBo.setInvoiceBo(UocRu.js(uocOrdInvoice, UocGetSaleOrderDetailServiceRspInvoiceBo.class));
        log.info("设置发票信息");


        //查询发票邮寄信息
        UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo = new UocGetSaleOrderDetailServiceRspReceiverAddressBo();
        if (ObjectUtil.isNotEmpty(uocOrdInvoice)&&uocOrdInvoice.getContactId()!=null) {
            relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setContactId(uocOrdInvoice.getContactId());
            relaQryBo.setOrderId(uocOrdInvoice.getOrderId());
            relaQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            invoiceAddressBo = UocRu.js(this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo), UocGetSaleOrderDetailServiceRspReceiverAddressBo.class);
        }
        //设置发票邮寄信息
        rspBo.setInvoiceAddressBo(invoiceAddressBo);

        //查询销售单附件
        //查询所有附件
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocOrderAccessoryQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAccessory> saleOrderAccessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap =
                    accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }

        //查询销售单主体扩展
        List<UocBaseExtParallelBo> uocBaseExtParallelBoList = new ArrayList<>();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
        uocSaleOrderMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            uocBaseExtParallelBoList = UocRu.jsl(saleOrderExpandList, UocBaseExtParallelBo.class);
        }
        //设置销售单纵向拓展信息
        rspBo.setSaleOrderDetailServiceRspExtBoList(uocBaseExtParallelBoList);
        Map<String, List<UocSaleOrderMap>> collectMap = saleOrderExpandList.stream().collect(Collectors.groupingBy(UocSaleOrderMap::getFieldCode));
        rspBo.setBudgetModelCode(CollUtil.isNotEmpty(collectMap.get("budgetModelCode")) ? collectMap.get("budgetModelCode").get(0).getFieldValue() : null);
        rspBo.setBudgetModelName(CollUtil.isNotEmpty(collectMap.get("budgetModelName")) ? collectMap.get("budgetModelName").get(0).getFieldValue() : null);
        rspBo.setFinancialId(CollUtil.isNotEmpty(collectMap.get("financialId")) ? collectMap.get("financialId").get(0).getFieldValue() : null);
        rspBo.setFinancialName(CollUtil.isNotEmpty(collectMap.get("financialName")) ? collectMap.get("financialName").get(0).getFieldValue() : null);
        rspBo.setCostCenterId(CollUtil.isNotEmpty(collectMap.get("costCenterId")) ? collectMap.get("costCenterId").get(0).getFieldValue() : null);
        rspBo.setCostCenterName(CollUtil.isNotEmpty(collectMap.get("costCenterName")) ? collectMap.get("costCenterName").get(0).getFieldValue() : null);
        rspBo.setRelevantDeptName(CollUtil.isNotEmpty(collectMap.get("relevantDeptName")) ? collectMap.get("relevantDeptName").get(0).getFieldValue() : null);
        rspBo.setBudgetProjectId(CollUtil.isNotEmpty(collectMap.get("budgetProjectId")) ? collectMap.get("budgetProjectId").get(0).getFieldValue() : null);
        rspBo.setBudgetProjectName(CollUtil.isNotEmpty(collectMap.get("budgetProjectName")) ? collectMap.get("budgetProjectName").get(0).getFieldValue() : null);
        rspBo.setUnifiedPurOrderFlag(CollUtil.isNotEmpty(collectMap.get("unifiedPurOrderFlag")) ? collectMap.get("unifiedPurOrderFlag").get(0).getFieldValue() : null);
        rspBo.setIncomeAndExpProjectId(CollUtil.isNotEmpty(collectMap.get("incomeAndExpProjectId")) ? collectMap.get("incomeAndExpProjectId").get(0).getFieldValue() : null);
        rspBo.setIncomeAndExpProjectName(CollUtil.isNotEmpty(collectMap.get("incomeAndExpProjectName")) ? collectMap.get("incomeAndExpProjectName").get(0).getFieldValue() : null);
        rspBo.setServiceFailTime(CollUtil.isNotEmpty(collectMap.get("serviceFailTime")) ? collectMap.get("serviceFailTime").get(0).getFieldValue() : null);
        rspBo.setServiceEffectiveTime(CollUtil.isNotEmpty(collectMap.get("serviceEffectiveTime")) ? collectMap.get("serviceEffectiveTime").get(0).getFieldValue() : null);


        //查询发货单
        Map<Long, UocShipOrderItem> shipOrderItemMap = new HashMap<>();
        List<UocShipOrderItem> allShipOrderItem = new ArrayList<>();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocShipOrderDo> shipOrderList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isNotEmpty(shipOrderList)) {
            for (UocShipOrderDo each : shipOrderList) {
                UocGetSaleOrderDetailServiceRspShipOrderInfoBo shipOrderInfoBo = UocRu.js(each, UocGetSaleOrderDetailServiceRspShipOrderInfoBo.class);
                //查询发货单明细
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setOrderId(each.getOrderId());
                uocShipOrderItemQryBo.setShipOrderId(each.getShipOrderId());
                uocShipOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                UocShipOrderDo listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                    shipOrderInfoBo.setShipOrderItemInfo(UocRu.jsl(listShipOrderItem.getShipOrderItemBoList(), UocGetSaleOrderDetailServiceRspShipOrderItemBo.class));
                    allShipOrderItem.addAll(listShipOrderItem.getShipOrderItemBoList());
                }
                shipOrderInfo.add(shipOrderInfoBo);
            }
        }

        if (!CollectionUtils.isEmpty(allShipOrderItem)) {
            Map<Long, List<UocShipOrderItem>> shipOrderItemMapGroupBySkuItem = allShipOrderItem.stream().collect(Collectors.groupingBy(UocShipOrderItem::getSaleOrderItemId));
            for (Map.Entry<Long, List<UocShipOrderItem>> entry : shipOrderItemMapGroupBySkuItem.entrySet()) {
                BigDecimal sendCount = entry.getValue().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inspCount = entry.getValue().stream().map(UocShipOrderItem::getInspCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setSendCount(sendCount);
                uocShipOrderItem.setInspCount(inspCount);
                shipOrderItemMap.put(entry.getKey(), uocShipOrderItem);
            }
            log.debug("shipOrderItemMapGroupBySkuItem明细:" + JSON.toJSONString(shipOrderItemMapGroupBySkuItem));
            log.debug("shipOrderItemMap明细:" + JSON.toJSONString(shipOrderItemMap));
        }
        //查询验收单
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            for (UocInspOrderDo each : inspOrderList) {
                UocGetSaleOrderDetailServiceRspInspOrderInfoBo inspOrderInfoBo = UocRu.js(each, UocGetSaleOrderDetailServiceRspInspOrderInfoBo.class);
                //查询验收单明细
                UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
                uocInspOrderItemQryBo.setOrderId(each.getOrderId());
                uocInspOrderItemQryBo.setInspOrderId(each.getInspOrderId());
                uocInspOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                UocInspOrderDo listInspOrderItem = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
                if (null != listInspOrderItem && ObjectUtil.isNotEmpty(listInspOrderItem.getUocInspOrderItemList())) {
                    inspOrderInfoBo.setInspOrderItemInfo(UocRu.jsl(listInspOrderItem.getUocInspOrderItemList(), UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo.class));
                }
                inspOrderInfo.add(inspOrderInfoBo);
            }
        }
        //查询支付单
        UocOrderShouldPay uocPayOrderQryBo = new UocOrderShouldPay();
        uocPayOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        if(saleOrderMainInfo.getStakeholder() != null && StringUtils.isNotEmpty(saleOrderMainInfo.getStakeholder().getPurCompanyId())){
            uocPayOrderQryBo.setPayerId(Long.valueOf(saleOrderMainInfo.getStakeholder().getPurCompanyId()));
        }
        //贸易模式且查询方为供应侧
        if (saleOrderMainInfo.getModelSettle().equals(UocConstant.ModelSettle.MY) && "2".equals(reqBo.getIsProfessionalOrgExt())){
            uocPayOrderQryBo.setPayerId(Long.valueOf(saleOrderMainInfo.getStakeholder().getProId()));
        }
        uocPayOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderShouldPay> listPayOrder = this.iUocPayOrderModel.getListOrderShouldPay(uocPayOrderQryBo);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            List<UocGetSaleOrderDetailServiceRspShouldPayOrderBo> shouldPayOrderBoList = UocRu.jsl(listPayOrder, UocGetSaleOrderDetailServiceRspShouldPayOrderBo.class);
            rspBo.setPayOrderInfo(shouldPayOrderBoList);
        }
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        uocSaleOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            Map<String, List<UocSaleOrderItem>> saleItemCommodityTypeMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getCommodityTypeId));
            List<UocGetSaleOrderDetailServiceRspItemBo> commodityTypeInspSuperCountList = new ArrayList<>();
            saleItemCommodityTypeMap.forEach((k,v)->{
                //总采购数量
                BigDecimal purchaseCount = new BigDecimal(0);
                AtomicReference<Integer> inspectionExcessPercent = new AtomicReference<>();
                //总超验数量
                BigDecimal inspSuperCount = new BigDecimal(0);
                for (UocSaleOrderItem m : v) {
                    purchaseCount = purchaseCount.add(m.getPurchaseCount());
                    inspectionExcessPercent.set(m.getInspectionExcessPercent()== null ? 0 : m.getInspectionExcessPercent());
                    inspSuperCount = inspSuperCount.add(m.getInspSuperCount() == null ? new BigDecimal(0) : m.getInspSuperCount());
                }
                //剩余超验数量
                BigDecimal remainInspSuperCount = purchaseCount.multiply(new BigDecimal(inspectionExcessPercent.get())).divide(BigDecimal.valueOf(100)).subtract(inspSuperCount);
                if (remainInspSuperCount.compareTo(new BigDecimal(0)) < 0 ) {
                    remainInspSuperCount = new BigDecimal(0);
                }
                UocGetSaleOrderDetailServiceRspItemBo uocSaleOrderItem = new UocGetSaleOrderDetailServiceRspItemBo();
                uocSaleOrderItem.setCommodityTypeId(k);
                uocSaleOrderItem.setInspSuperCount(remainInspSuperCount);
                commodityTypeInspSuperCountList.add(uocSaleOrderItem);
            });
            rspBo.setCommodityTypeInspSuperCountList(commodityTypeInspSuperCountList);
            for (UocSaleOrderItem item : saleOrderItemList) {
                UocGetSaleOrderDetailServiceRspItemBo rspItemBo = UocRu.js(item, UocGetSaleOrderDetailServiceRspItemBo.class);
                //发货数量
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setSendCount(shipOrderItemMap.get(item.getSaleOrderItemId()).getSendCount());
                }
                //验收数量
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setAcceptanceCount(shipOrderItemMap.get(item.getSaleOrderItemId()).getInspCount());
                }
                if (null == rspItemBo.getPurchaseFee()) {
                    //采购金额
                    if (null != rspItemBo.getPurchasePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setPurchaseFee(rspItemBo.getPurchasePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getSaleFee()) {
                    //销售金额
                    if (null == rspItemBo.getSalePrice()) {
                        rspItemBo.setSalePrice(rspItemBo.getPurchasePrice());
                    }
                    if (null != rspItemBo.getSalePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setSaleFee(rspItemBo.getSalePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getMarkUpRate()) {
                    rspItemBo.setMarkUpRate(BigDecimal.ZERO.doubleValue());
                }
                //调价后销售价
                rspItemBo.setSalePriceRear(rspItemBo.getSalePrice());
                //调价后采购价
                rspItemBo.setPurchasePriceRear(rspItemBo.getPurchasePrice());
                //调价后加价率
                if (null != rspItemBo.getSalePriceRear() && null != rspItemBo.getPurchasePriceRear()) {
                    rspItemBo.setMarkUpRateRear(rspItemBo.getSalePriceRear().subtract(rspItemBo.getPurchasePriceRear()).abs().divide(rspItemBo.getPurchasePriceRear(), 2).doubleValue());
                }
                //设置铺货单位
                rspItemBo.setDistirbutionId(saleOrderMainInfo.getStakeholder().getProId());
                //设置铺货单位名称
                rspItemBo.setDistirbutionName(saleOrderMainInfo.getStakeholder().getProName());

                //查询销售单明细扩展
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(item.getSaleOrderItemId());
                uocSaleItemMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                List<UocSaleItemMap> saleOrderItemMapList = this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
                    List<UocBaseExtParallelBo> uocBaseExtParallelBos = UocRu.jsl(saleOrderItemMapList, UocBaseExtParallelBo.class);
                    rspItemBo.setItemExtParallelBos(uocBaseExtParallelBos);
                    if (ObjectUtil.equal(rspItemBo.getItemType(), UocDicConstant.ITEM_TYPE.COMMODITY_SKU)) {
                        rspItemBo.setCommExtParallelBos(uocBaseExtParallelBos);
                    }
                    //供货周期
                    rspItemBo.setDeliveryTimeDate(deliveryCycle(rspItemBo,saleOrderMainInfo,uocBaseExtParallelBos));
                    Map<String, List<UocBaseExtParallelBo>> itemExtMap = uocBaseExtParallelBos.stream().collect(Collectors.groupingBy(UocBaseExtParallelBo::getFieldCode));
                    rspItemBo.setPurchasePurposeName(CollUtil.isNotEmpty(itemExtMap.get("purchasePurposeName")) ? itemExtMap.get("purchasePurposeName").get(0).getFieldValue() : null);
                    rspItemBo.setPurchasePurposeId(CollUtil.isNotEmpty(itemExtMap.get("purchasePurposeId")) ? itemExtMap.get("purchasePurposeId").get(0).getFieldValue() : null);
                    rspItemBo.setCmoomdityClass(CollUtil.isNotEmpty(itemExtMap.get("cmoomdityClass")) ? itemExtMap.get("cmoomdityClass").get(0).getFieldValue() : null);

                }
                uocGetSaleOrderDetailServiceRspItemBos.add(rspItemBo);
                log.info("rspItemBo:"+JSON.toJSONString(rspItemBo));
            }
        }

        //查询外部电商信息
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMainInfo.getOrderSource())) {
            UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
            queryIndexQryBo.setOrderId(saleOrderMainInfo.getOrderId());
            queryIndexQryBo.setObjId(reqBo.getSaleOrderId());
            queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            queryIndexQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderQueryIndex> uocOrderQueryIndices = this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndices)) {
                rspBo.setOutOrderId(uocOrderQueryIndices.get(0).getOutObjId());
            }
        }
        //查询审批单
        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(saleOrderMainInfo.getOrderId(), reqBo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE,dataAchiveTabSuffix);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));
        //查询整单审批单
        List<UocAuditOrderDo> wholeAuditOrderList = getAuditOrderList(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER,dataAchiveTabSuffix);
        rspBo.setWholeAuditOrderBoList(UocRu.jsl(wholeAuditOrderList, UocSaleOrderAuditBO.class));

        //查询销售单所在得审批单
        List<UocAuditOrderDo> approvalPlusAuditOrderList = getAuditOrderList(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE,dataAchiveTabSuffix);
        rspBo.setApprovalPlusAuditOrderList(UocRu.jsl(approvalPlusAuditOrderList, UocSaleOrderAuditBO.class));
        
        //附件分组
        if (ObjectUtil.isNotEmpty(accessoryDetailBoList)) {
            ConcurrentMap<Integer, List<UocBaseOrderAccessoryTypeDetailBo>> accessoryMap =
                    accessoryDetailBoList.stream().collect(Collectors.groupingByConcurrent(UocBaseOrderAccessoryTypeDetailBo::getAttachmentType));
            //下单附件，去重订单、销售单附件
            if(!CollectionUtils.isEmpty(accessoryMap.get(UocAttachementTypeConstants.CREATE_ORDER))){
                List<UocBaseOrderAccessoryTypeDetailBo> uocBaseOrderAccessoryTypeDetailBos = accessoryMap.get(UocAttachementTypeConstants.CREATE_ORDER);
                for (UocBaseOrderAccessoryTypeDetailBo uocBaseOrderAccessoryTypeDetailBo : uocBaseOrderAccessoryTypeDetailBos) {
                    List<UocBaseOrderAccessoryDetailBo> attchList = uocBaseOrderAccessoryTypeDetailBo.getAttchList().stream().filter(v -> v.getObjType() == 1).collect(Collectors.toList());
                    uocBaseOrderAccessoryTypeDetailBo.setAttchList(attchList);
                }
                //附件类型增加--优化原始逻辑
                //rspBo.setOrderAccessoryList(uocBaseOrderAccessoryTypeDetailBos);

            }
            rspBo.setOrderAccessoryList(accessoryDetailBoList);
            //据单附件
            rspBo.setRejectAccessoryList(accessoryMap.get(UocAttachementTypeConstants.SALE_ORDER_REJECT));
            //取消订单附件
            rspBo.setCancelAccessoryList(accessoryMap.get(UocAttachementTypeConstants.CANCEL_SALE_ORDER));
            //取消申请订单附件
            rspBo.setCancelApplyAccessoryList(accessoryMap.get(UocAttachementTypeConstants.CANCEL_APPLY_SALE_ORDER));
            //到货登记订单附件
            rspBo.setArriveRegistAccessoryList(accessoryMap.get(UocAttachementTypeConstants.ARRIVAL_REGIST));
        }
        rspBo.setSaleOrderDetailServiceRspItemBoList(uocGetSaleOrderDetailServiceRspItemBos);
        rspBo.setShipOrderInfo(shipOrderInfo);
        rspBo.setInspOrderInfo(inspOrderInfo);
        //字段翻译
        translateProperties(rspBo);
        //判断供应商是否确认,是否有收发货详情展示
        judgeSupplierConfirm(rspBo);

        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 查询订单协议信息
     * @param order
     * @param agrDataId
     * @return
     */
    private UocGetSaleOrderDetailServiceRspAgreementInfoBo queryOrderAgrInfo(Long order,Long agrDataId,String dataAchiveTabSuffix){
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(order);
        uocOrderAgreementQryBo.setId(agrDataId);
        uocOrderAgreementQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
        if(!CollectionUtils.isEmpty(agreementOrderList)){
            UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfoBo = new UocGetSaleOrderDetailServiceRspAgreementInfoBo();
            BeanUtils.copyProperties(agreementOrderList.get(0),agreementInfoBo);
            return agreementInfoBo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询订单协议信息失败");
        }
    }

    /**
     * 查询主订单信息
     * @param orderId
     * @return
     */
    private UocOrderDo queryOrderInfo(Long orderId,String dataAchiveTabSuffix){
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        uocOrderDo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        if(null != orderInfo){
            return orderInfo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询主订单信息失败");
        }
    }

    /**
     * 查询销售单主体信息
     * @param reqBo
     * @return
     */
    private UocSaleOrderDo querySaleOrderMainInfo(UocGetSaleOrderDetailServiceReqBo reqBo,String dataAchiveTabSuffix){
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        uocSaleOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        return saleOrderMainInfo;
    }

    private void judgeSupplierConfirm(UocGetSaleOrderDetailServiceRspBo rspBo) {
        String saleOrderStateStr = rspBo.getSaleOrderStateStr();
        Boolean isSupConfirm = false;
        if (ObjectUtil.notEqual(saleOrderStateStr, "分配中")
            && ObjectUtil.notEqual(saleOrderStateStr, "核实中")
            && ObjectUtil.notEqual(saleOrderStateStr, "复核中")
            && ObjectUtil.notEqual(saleOrderStateStr, "待确认")) {
            isSupConfirm = true;
        }
        rspBo.setIsSupplierConfirmFlag(isSupConfirm);
        //有发货信息
        rspBo.setIsShipFlag(false);
        if(!CollectionUtils.isEmpty(rspBo.getShipOrderInfo())) rspBo.setIsShipFlag(true);
    }

    /**
     * 查询流程相关信息
     * @param uocSaleOrderDo
     * @param isSale
     * @return
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocSaleOrderDo uocSaleOrderDo, String isSale,String dataAchiveTabSuffix) {
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        Boolean isSaleFlag = false;
        //查询流程任务实例
        if (StringUtils.isNotBlank(isSale) && isSale.equals("1")) {
            //设置查询条件：单据id为销售单id
            procInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
            //设置查询条件：单据类型为销售单
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            isSaleFlag = true;
        }
        //设置查询条件：订单id
        procInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        //设置查询条件：完结标志为未完结
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        procInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            List<UocGetSaleOrderDetailServiceRspPorcBo> procBoList = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class);
            Map<Integer, List<UocGetSaleOrderDetailServiceRspPorcBo>> procBosMap = procBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspPorcBo::getObjType));
            if (ObjectUtil.isNotEmpty(procBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                procInst = procBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0);
            }
            List<UocOrderTaskInst> uocOrderTaskInsts = new ArrayList<>();
            if (isSaleFlag) {
                //查询销售单流程对应的任务
                uocOrderTaskInsts.addAll(this.getOrderTaskInsts(procInst,dataAchiveTabSuffix));
            } else {
                //查询非销售单流程对应的任务
                procBoList.forEach(bo -> {
                    uocOrderTaskInsts.addAll(this.getOrderTaskInsts(bo,dataAchiveTabSuffix));
                });
            }

            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                Map<Integer, List<UocGetSaleOrderDetailServiceRspTaskBo>> taskBosMap = taskBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspTaskBo::getObjType));
                taskBoList.forEach(each -> {
                    //查询任务处理实例
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                //为了联调，先取第一个环节编码和任务id
                if (ObjectUtil.isNotEmpty(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                    procInst.setProcState(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getProcState());
                    procInst.setTaskId(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getTaskInstId());
                }
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    /**
     * 查询已完成环节任务相关信息-移动端使用
     * @param uocSaleOrderDo
     * @return
     */
    private List<UocGetSaleOrderDetailServiceRspPorcBo> getProcTacheFinish(UocSaleOrderDo uocSaleOrderDo ,String dataAchiveTabSuffix) {
        List<UocGetSaleOrderDetailServiceRspPorcBo> proInstFinishList = new ArrayList<>();
        List<UocOrderTaskInst> orderTaskInstsAll = getOrderTaskInstsAll(uocSaleOrderDo,dataAchiveTabSuffix);
        if (!CollectionUtils.isEmpty(orderTaskInstsAll)) {
            orderTaskInstsAll.forEach(v -> {
                UocGetSaleOrderDetailServiceRspPorcBo bo = new UocGetSaleOrderDetailServiceRspPorcBo();
                BeanUtils.copyProperties(v,bo);
                bo.setFinishTag(v.getFinishTag());
                bo.setProcState(v.getProcState());
                bo.setFinishTime(v.getFinishTime());
                proInstFinishList.add(bo);
            });
        }
        return proInstFinishList;
    }

    /**
     * 查询审批流程任务实例
     *
     * @param uocSaleOrderDo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocSaleOrderDo uocSaleOrderDo, Integer objType,String dataAchiveTabSuffix) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        //销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getSaleOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {//整单
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        uocApprovalObjQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    uocApprovalObjQryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);
                //取审批未结束的审批实例Id
                String procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (StringUtils.isNotBlank(procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }

        }
        return procInst;
    }

    /**
     * 查询流程任务
     * @param procInst
     * @return
     */
    private List<UocOrderTaskInst> getOrderTaskInsts(UocGetSaleOrderDetailServiceRspPorcBo procInst,String dataAchiveTabSuffix) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(procInst.getObjId());
        taskInstQryBo.setObjType(procInst.getObjType());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }
    private List<UocOrderTaskInst> getOrderTaskInstsAll(UocSaleOrderDo uocSaleOrderDo,String dataAchiveTabSuffix) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }

    /**
     * 查询审批单
     *
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType,String dataAchiveTabSuffix) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr(objId));
        obj.setObjType(objType);
        obj.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        log.info("查询uocApprovalObjs：{}",JSON.toJSONString(uocApprovalObjs));
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        auditOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        log.info("查询uocAuditOrders：{}",JSON.toJSONString(uocAuditOrders));
    
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                // 查询流程实例
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                procInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                log.info("查询uocOrderProcInsts：{}",JSON.toJSONString(uocOrderProcInsts));
    
                if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        /*销售单主体*/
        //销售单状态字典
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        //无协议
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE);
        //协议
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE);
        //电商
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM);
        //订单来源字典
        pCodeList.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        //付款方式字典
        pCodeList.add(UocDicConstant.PAY_TYPE.P_CODE);
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
        //竣工标志字典
        pCodeList.add(UocDicConstant.FINISH_FLAG.P_CODE);
        //结算模式字典
        pCodeList.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        //采购类别字典
        pCodeList.add(UocDicConstant.PURCHASE_TYPE.P_CODE);
        //采购模式字典
        pCodeList.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        /*发票信息*/
        //发票类型字典
        pCodeList.add(UocDicConstant.INVOICE_TYPE.P_CODE);
        //发票类别字典
        pCodeList.add(UocDicConstant.INVOICE_CATEGORY.P_CODE);
        /*附件信息*/
        //附件类型字典
        pCodeList.add(UocDicConstant.ATTACHMENT_TYPE.P_CODE);
        //单据类型字典
        pCodeList.add(UocDicConstant.OBJ_TYPE.P_CODE);
        /*销售单明细信息*/
        //明细类型字典
        pCodeList.add(UocDicConstant.ITEM_TYPE.P_CODE);
        /*任务处理信息*/
        //处理对象类型字典
        pCodeList.add(UocDicConstant.DEAL_TYPE.P_CODE);
        //处理分类字典
        pCodeList.add(UocDicConstant.DEAL_CLASS.P_CODE);
        /*协议信息*/
        //协议模式字典
        pCodeList.add(UocDicConstant.AGREEMENT_MODE.P_CODE);
        //调价机制字典
        pCodeList.add(UocDicConstant.ADJUST_PRICE.P_CODE);
        //发货单状态字典
        pCodeList.add(UocStateConstants.ShipOrder.P_CODE);
        //验收单状态字典
        pCodeList.add(UocStateConstants.InspOrder.P_CODE);
        //应付单状态字典
        pCodeList.add(UocDicConstant.SHOULD_PAY_TYPE.P_CODE);
        //销售单环节状态字典
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_ALL_MAIN);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(UocGetSaleOrderDetailServiceRspBo rspBo) {
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            /*销售单主体*/
            //销售单状态翻译
            Integer orderSource = rspBo.getOrderSource();
            String saleOrderState = rspBo.getSaleOrderState();
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = rspBo.getProcInst();
            List<String> stateList = new ArrayList<>();
            if (StringUtils.isNotBlank(saleOrderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
                if (UocStateConstants.SaleOrder.XS_FH_FHWC.equals(saleOrderState) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(saleOrderState)) {
                    stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHZ);
                    stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHWC);
                } else if (UocStateConstants.SaleOrder.XS_FH_DFH.equals(saleOrderState) && UocStateConstants.SaleTachCode.TC3_DFH.equals(busiProcInst.getProcState())) {
                    stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
                    stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
                    stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
                } else {
                    stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
                }
            } else if (StringUtils.isNotBlank(saleOrderState)) {
                stateList.add(saleOrderState);
            } else if (StringUtils.isNotBlank(busiProcInst.getProcState())) {
                if (UocStateConstants.SaleTachCode.TC1_DFH.equals(busiProcInst.getProcState())
                        || UocStateConstants.SaleTachCode.TC2_DFH.equals(busiProcInst.getProcState())) {
                    stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
                    stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
                    stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
                } else {
                    stateList.add(busiProcInst.getProcState());
                }
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE)) && UocConstant.SkuSource.SELF.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE).get(stateList.get(0)));
                }
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM)) && UocConstant.SkuSource.ELC.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM).get(stateList.get(0)));
                }
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE)) && UocConstant.SkuSource.AGR.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE).get(stateList.get(0)));
                }
            }
            //订单来源翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE).get(rspBo.getOrderSource().toString()));
            }
            //付款方式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE))) {
                rspBo.setPayTypeStr(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(rspBo.getPayType()));
            }
            //支付状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPayState())) {
                rspBo.setPayStateStr(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(rspBo.getPayState().toString()));
            }
            //竣工标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE).get(rspBo.getFinishFlag().toString()));
            }
            //结算模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(rspBo.getModelSettle().toString()));
            }
            //采购类别翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE).get(rspBo.getPurchaseType().toString()));
            }
            //采购模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseMode())) {
                rspBo.setPurchaseModeStr(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(rspBo.getPurchaseMode().toString()));
            }
            /*发票信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getInvoiceBo())) {
                UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo = rspBo.getInvoiceBo();
                //发票类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoiceType())) {
                    invoiceBo.setInvoiceTypeStr(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE).get(invoiceBo.getInvoiceType().toString()));
                }
                //发票类别翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoceCategory())) {
                    invoiceBo.setInvoceCategoryStr(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE).get(invoiceBo.getInvoceCategory().toString()));
                }
            }
            /*附件信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getOrderAccessoryList())) {
                translateAccessory(rspBo, UocAttachementTypeConstants.CREATE_ORDER, dictionaryMap);
            }
            if (ObjectUtil.isNotEmpty(rspBo.getRejectAccessoryList())) {
                translateAccessory(rspBo, UocAttachementTypeConstants.SALE_ORDER_REJECT, dictionaryMap);
            }
            if (ObjectUtil.isNotEmpty(rspBo.getCancelAccessoryList())) {
                translateAccessory(rspBo, UocAttachementTypeConstants.CANCEL_SALE_ORDER, dictionaryMap);
            }
            /*销售单明细信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getSaleOrderDetailServiceRspItemBoList())) {
                rspBo.getSaleOrderDetailServiceRspItemBoList().forEach(each -> {
                    //明细类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getItemType())) {
                        each.setItemTypeStr(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE).get(each.getItemType().toString()));
                    }
                });
            }
            /*协议信息*/
            if (ObjectUtil.isNotNull(rspBo.getAgreementInfo())) {
                UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo = rspBo.getAgreementInfo();
                //协议模式翻译
                if (null != agreementInfo.getAgreementCode()) {
                    agreementInfo.setAgreementCodeStr(dictionaryMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE).get(agreementInfo.getAgreementCode().toString()));
                }
                //调价机制翻译
                if (null != agreementInfo.getAdjustPrice()) {
                    agreementInfo.setAdjustPriceStr(dictionaryMap.get(UocDicConstant.ADJUST_PRICE.P_CODE).get(agreementInfo.getAdjustPrice().toString()));
                }
            }
            /*流程数据*/
            if (ObjectUtil.isNotEmpty(rspBo.getProcInst())) {
                UocGetSaleOrderDetailServiceRspPorcBo procInst = rspBo.getProcInst();
                //流程单据类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(procInst.getObjType())) {
                    procInst.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(procInst.getObjType().toString()));
                }
                if (ObjectUtil.isNotEmpty(procInst.getTaskList())) {
                    procInst.getTaskList().forEach(each -> {
                        //任务单据类型翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getObjType())) {
                            each.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(each.getObjType().toString()));
                        }
                        if (ObjectUtil.isNotEmpty(each.getTaskDealBo())) {
                            for (UocGetSaleOrderDetailServiceRspTaskDealBo taskDealBo : each.getTaskDealBo()) {
                                //任务处理单据类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getObjType())) {
                                    taskDealBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(taskDealBo.getObjType().toString()));
                                }
                                //处理对象类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getDealType())) {
                                    taskDealBo.setDealTypeStr(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE).get(taskDealBo.getDealType().toString()));
                                }
                                //处理分类翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE))) {
                                    taskDealBo.setDealClassStr(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE).get(taskDealBo.getDealClass()));
                                }
                            }
                        }
                    });
                }
            }
            /*发货单信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getShipOrderInfo())) {
                rspBo.getShipOrderInfo().forEach(each -> {
                    //发货单状态翻译
                    each.setShipOrderStateStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(each.getShipOrderState()));
                    if (ObjectUtil.isNotEmpty(each.getShipOrderItemInfo())) {
                        each.getShipOrderItemInfo().forEach(item -> {
                            //明细状态翻译
                            item.setShipItemStateStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(item.getShipItemState()));
                        });
                    }
                });
            }
            /*验收单信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getInspOrderInfo())) {
                rspBo.getInspOrderInfo().forEach(each -> {
                    //发货单状态翻译
                    each.setInspOrderStateStr(dictionaryMap.get(UocStateConstants.InspOrder.P_CODE).get(each.getInspOrderState()));
                    if (ObjectUtil.isNotEmpty(each.getInspOrderItemInfo())) {
                        each.getInspOrderItemInfo().forEach(item -> {
                            //明细状态翻译
                            item.setInspItemStatusStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(item.getInspItemStatus()));
                        });
                    }
                });
            }
            if (ObjectUtil.isNotEmpty(rspBo.getPayOrderInfo())){
                rspBo.getPayOrderInfo().forEach(v->{
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SHOULD_PAY_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(v.getShouldPayType())) {
                        v.setShouldPayTypeStr(dictionaryMap.get(UocDicConstant.SHOULD_PAY_TYPE.P_CODE).get(String.valueOf(v.getShouldPayType())));
                    }
                    if(v.getIsPayCompleted().equals(1)){
                        v.setIsPayCompletedStr("已付款");
                    } else {
                        v.setIsPayCompletedStr("待付款");
                    }
                });
            }
            if (ObjectUtil.isNotEmpty(rspBo.getFinishTacheInfo()) && ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ALL_MAIN))){
                List<UocGetSaleOrderDetailServiceRspPorcBo> collect = rspBo.getFinishTacheInfo().stream()
                        .filter(v -> dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ALL_MAIN).get(v.getProcState()) != null)
                        .collect(Collectors.toList());
                collect.forEach(value->{
                    value.setProcStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ALL_MAIN).get(value.getProcState()));
                });
                rspBo.setFinishTacheInfo(collect);
            }
        }
    }

    private void translateAccessory(UocGetSaleOrderDetailServiceRspBo rspBo, Integer accessoryType, Map<String, Map<String, String>> dictionaryMap) {
        List<UocBaseOrderAccessoryTypeDetailBo> accessoryList;
        if (ObjectUtil.equal(accessoryType, UocAttachementTypeConstants.SALE_ORDER_REJECT)) {
            accessoryList = rspBo.getRejectAccessoryList();
        } else if (ObjectUtil.equal(accessoryType, UocAttachementTypeConstants.CANCEL_SALE_ORDER)) {
            accessoryList = rspBo.getCancelAccessoryList();
        } else {
            accessoryList = rspBo.getOrderAccessoryList();
        }
        accessoryList.forEach(each -> {
            //附件类型翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getAttachmentType())) {
                each.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(each.getAttachmentType().toString()));
            }
            if (ObjectUtil.isNotEmpty(each.getAttchList())) {
                for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                    //单据类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getObjType())) {
                        accessoryDetailBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(accessoryDetailBo.getObjType().toString()));
                    }
                    //附件类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getAttachmentType())) {
                        accessoryDetailBo.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(accessoryDetailBo.getAttachmentType().toString()));
                    }
                }
            }
        });
    }

    private String deliveryCycle(UocGetSaleOrderDetailServiceRspItemBo rspItemBo,UocSaleOrderDo uocSaleOrderDo,List<UocBaseExtParallelBo> uocBaseExtParallelBos){
        Map<String, List<UocBaseExtParallelBo>> collect = uocBaseExtParallelBos.stream().collect(Collectors.groupingBy(UocBaseExtParallelBo::getFieldCode));
        //供货周期file_code
        List<UocBaseExtParallelBo> deliveryCycle = collect.get("delivery_cycle");
        String arriveTime = null;
        if(!CollectionUtils.isEmpty(deliveryCycle)){
             arriveTime = deliveryCycle.get(0).getFieldValue();
            //供应商确认，拒单原因必填，接单后：交货日期=订单接单日期+供货周期
            if(null != uocSaleOrderDo.getRejectTime() && null == uocSaleOrderDo.getRejectReason()){
                long time = uocSaleOrderDo.getRejectTime().getTime() + (Long.parseLong(arriveTime) * 24 * 60 * 60 * 1000);
                Date date = new Date();
                date.setTime(time);
                arriveTime = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm").format(date);
            }
        }
        return arriveTime;
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void validateParam(UocGetSaleOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
    }
}