/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UocEsSyncManager {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncManager.class);
    private final Map<String, IUocEsSync> manageMap = new ConcurrentHashMap<String, IUocEsSync>();
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    private static final String OBJ_JSON = "objJson";

    public void saveData(UocEsSyncManagerSaveDataReqBo obyType) {
        String indexName = obyType.getIndexName();
        IUocEsSync interObj = this.manageMap.get(indexName);
        if (interObj == null) {
            throw new BaseBusinessException("8888", "\u7d22\u5f15\u540c\u6b65\u5b9e\u73b0\u7c7b\uff08" + indexName + "\uff09\u672a\u627e\u5230\u5b9e\u73b0\u7c7b");
        }
        this.validateQryReqBo(obyType);
        try {
            IUocEsSyncQryRspBo qryRspBo = interObj.qryData(UocRu.js(obyType, IUocEsSyncQryReqBo.class));
            if (!qryRspBo.getSyncFlag().booleanValue()) {
                return;
            }
            this.validateRspArg(qryRspBo);
            JSONObject data = qryRspBo.getJsonObj();
            this.uocElasticsearchUtil.addJsonData(interObj.indexName(), qryRspBo.getObjId().toString(), data.toJSONString());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public void deleteData(UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo) {
        String indexName = uocEsSyncManagerSaveDataReqBo.getIndexName();
        this.validateQryReqBo(uocEsSyncManagerSaveDataReqBo);
        IUocEsSync interObj = this.manageMap.get(indexName + "_delete");
        IUocEsSyncQryRspBo qryRspBo = interObj.qryData(UocRu.js(uocEsSyncManagerSaveDataReqBo, IUocEsSyncQryReqBo.class));
        if (null == qryRspBo || null == qryRspBo.getJsonObj()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[json]\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String endPoint = "/" + indexName + "/_delete_by_query";
        this.uocElasticsearchUtil.deleteDataByCondition(endPoint, qryRspBo.getJsonObj());
    }

    public Boolean updateData(UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo) {
        String indexName = uocEsSyncManagerSaveDataReqBo.getIndexName();
        if (null == uocEsSyncManagerSaveDataReqBo.getJsonObj()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[json]\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocEsSyncManagerSaveDataReqBo.getObjId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ID[objId]\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String endPoint = "/" + indexName + "/_update_by_query?refresh=true";
        return this.uocElasticsearchUtil.updateDataById(endPoint, uocEsSyncManagerSaveDataReqBo.getJsonObj(), uocEsSyncManagerSaveDataReqBo.getObjId().toString());
    }

    private void validateQryReqBo(UocEsSyncManagerSaveDataReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocEsSyncManagerSaveDataReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getIndexName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7d22\u5f15\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateRspArg(IUocEsSyncQryRspBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[IUocEsSyncQryRspBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getJsonObj())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[json]\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void register(IUocEsSync intObj) {
        String indexName = intObj.indexName();
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        Assert.notNull((Object)indexName, (String)"indexName can not be null");
        IUocEsSync intRet = this.manageMap.get(indexName);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e0d\u540c\u7d22\u5f15\u5b9e\u73b0\u7c7b\u7f16\u7801(" + indexName + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(UocEsSyncManager.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u4e0d\u540c\u7d22\u5f15\u5b9e\u73b0\u7c7b\uff1a" + indexName);
        this.manageMap.put(indexName, intObj);
    }
}

