/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceBySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqSaleItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceBySaleOrderService"})
public class UocArrvalAcceptanceBySaleOrderServiceImpl
implements UocArrvalAcceptanceBySaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceBySaleOrderServiceImpl.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";
    @Value(value="${uoc.createOrderSettleRelInfo:false}")
    private boolean createOrderSettleRelInfo;

    @PostMapping(value={"dealArrvalAcceptance"})
    public UocArrvalAcceptanceBySaleOrderRspBo dealArrvalAcceptance(@RequestBody UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo, reqBo.getSaleOrderItemList().stream().map(UocCreateInspOrderReqSaleItemBo::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        this.updateSaleOrderInfo(reqBo, saleOrderItemInfos);
        Long inspOrderId = this.createInspOrder(reqBo, saleOrderItemInfos);
        this.createOrderSettleRelInfo(reqBo, inspOrderId);
        Boolean inspFinish = this.determineFinishAndUpdateSaleState(reqBo);
        UocArrvalAcceptanceBySaleOrderRspBo rspBo = UocRu.success(UocArrvalAcceptanceBySaleOrderRspBo.class);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setFinish(inspFinish);
        rspBo.setOpFlag(inspFinish != false ? OP_FLAG_YES : "0");
        rspBo.setInspOrderId(inspOrderId);
        return rspBo;
    }

    private Boolean determineFinishAndUpdateSaleState(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        if (reqBo.getInspFinish().booleanValue()) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            this.updateSaleOrderState(saleOrderItemList, reqBo);
            this.submitSaleOrderTask(reqBo);
            return true;
        }
        return false;
    }

    private void submitSaleOrderTask(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBo.setStepId(reqBo.getStepId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private Long createInspOrder(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        Long inspOrderId = IdUtil.nextId();
        createInspOrderDo.setOrderId(saleOrderItems.get(0).getOrderId());
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        createInspOrderDo.setInspOrderId(inspOrderId);
        createInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        createInspOrderDo.setInspOrderState("YS_YS_YS");
        createInspOrderDo.setInspOper(reqBo.getName());
        createInspOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createInspOrderDo.setCreateTime(new Date());
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        createInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        createInspOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        Map<Long, UocCreateInspOrderReqSaleItemBo> inspItemBOMap = reqBo.getSaleOrderItemList().stream().collect(Collectors.toMap(UocCreateInspOrderReqSaleItemBo::getSaleOrderItemId, e -> e));
        saleOrderItems.forEach(uocSaleOrderItem -> {
            UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
            createInspOrderItem.setOrderId(uocSaleOrderItem.getOrderId());
            createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
            createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            createInspOrderItem.setInspCount(((UocCreateInspOrderReqSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setRemainInspCount(((UocCreateInspOrderReqSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setInitInspCount(((UocCreateInspOrderReqSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            createInspOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            createInspOrderItem.setCreateTime(new Date());
            createInspOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocInspOrderItemList.add(createInspOrderItem);
        });
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        createInspOrderDo.setAllowChngTime(this.getInspAllowChngTime(reqBo));
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(((UocSaleOrderItem)((Object)((Object)saleOrderItems.get(0)))).getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        BigDecimal inspSaleMoney = BigDecimal.ZERO;
        BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
        for (UocInspOrderItem uocInspOrderItem : uocInspOrderItemList) {
            UocSaleOrderItem saleOrderItem = uocSaleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if (null != saleOrderItem.getSalePrice() && null != saleOrderItem.getPurchaseCount()) {
                BigDecimal inspSalFee = saleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                inspSaleMoney = inspSaleMoney.add(inspSalFee);
            }
            if (null == saleOrderItem.getPurchasePrice() || null == saleOrderItem.getPurchaseCount()) continue;
            BigDecimal purSalFee = saleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
            inspPurchaseMoney = inspPurchaseMoney.add(purSalFee);
        }
        createInspOrderDo.setTotalSaleFee(inspSaleMoney);
        createInspOrderDo.setTotalPurchaseFee(inspPurchaseMoney);
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);
        return inspOrderId;
    }

    private void updateSaleOrderInfo(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        updateSaleOrderDo.setUpdateTime(new Date());
        Map<Long, UocSaleOrderItem> dbSaleItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        for (UocCreateInspOrderReqSaleItemBo uocCreateInspOrderReqSaleItemBo : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem dbSaleItem = dbSaleItemMap.get(uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId());
            if (dbSaleItem == null) {
                throw new BaseBusinessException("101004", "\u9500\u552e\u5355\u660e\u7ec6id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]\u4e0d\u5b58\u5728");
            }
            if (dbSaleItem.getAcceptanceCount().add(uocCreateInspOrderReqSaleItemBo.getInspCount()).compareTo(dbSaleItem.getPurchaseCount()) <= 0) continue;
            throw new BaseBusinessException("101004", "\u9500\u552e\u5355\u660e\u7ec6id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]\u9a8c\u6536\u6570\u91cf\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf[" + dbSaleItem.getPurchaseCount() + "]\u4e86");
        }
        ArrayList<UocSaleOrderItem> updateItemList = new ArrayList<UocSaleOrderItem>();
        for (UocCreateInspOrderReqSaleItemBo value : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem updateItemDo = new UocSaleOrderItem();
            updateItemDo.setSaleOrderItemId(value.getSaleOrderItemId());
            updateItemDo.setAcceptanceCount(value.getInspCount());
            updateItemList.add(updateItemDo);
        }
        updateSaleOrderDo.setSaleOrderItems(updateItemList);
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
    }

    private void updateSaleOrderState(List<UocSaleOrderItem> saleOrderItemList, UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            int acceptanceCompleteItemCount = 0;
            for (UocSaleOrderItem uocSaleOrderItem : saleOrderItemList) {
                if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getAcceptanceCount()) != 0) continue;
                ++acceptanceCompleteItemCount;
            }
            if (acceptanceCompleteItemCount == saleOrderItemList.size()) {
                updateSaleOrderDo.setSaleOrderState("XS_YS_YS");
            } else {
                updateSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)updateSaleOrderDo.getSaleOrderState())) {
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }

    private Date getInspAllowChngTime(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            if (null != saleOrderMain) {
                String key = null;
                key = null != saleOrderMain.getStakeholder() ? saleOrderMain.getOrderSource() + saleOrderMain.getStakeholder().getSupId() : String.valueOf(saleOrderMain.getOrderSource()) + reqBo.getSupId();
                allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(key)) ? new Date(((UocConfEffective)confEffectiveMap.get(key)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(saleOrderMain.getOrderSource() + "0")).getAging());
            } else {
                allowChngTime = new Date(((UocConfEffective)confEffectiveMap.get("20")).getAging());
            }
        }
        return allowChngTime;
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }
        throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
    }

    private String getInspOrderNo(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if (null != inspOrderNo) {
                return inspOrderNo.getInspOrderNo();
            }
            throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25");
        }
        throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25\uff0c\u67e5\u8be2\u9500\u552e\u5355\u6570\u636e\u4e3a\u7a7a");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createOrderSettleRelInfo(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, Long inspOrderId) {
        if (!this.createOrderSettleRelInfo) return;
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null == saleOrderMain) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            return;
        } else {
            if (!UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7684\u7ed3\u7b97\u6a21\u5f0f");
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
        }
    }

    private void createRelInfo(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(relType);
        createOrderRel.setOrderId(reqBo.getOrderId());
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    private void verifyParam(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInspFinish()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5b8c\u7ed3\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        reqBo.getSaleOrderItemList().forEach(uocCreateInspOrderReqShipBo -> {
            if (null == uocCreateInspOrderReqShipBo.getSaleOrderItemId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocCreateInspOrderReqShipBo.getInspCount()) {
                throw new BaseBusinessException("100001", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

