package com.tydic.dyc.oc.model.bargaining.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.*;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class IUocBargainingModelImpl implements IUocBargainingModel {
    @Autowired
    private UocBargainingRepository uocBargainingRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Override
    public List<UocBargaining> getListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        if (null == uocBargainingQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryListBargaining(uocBargainingQryBo);
    }

    @Override
    public UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if(ObjectUtil.isEmpty(uocBargainingDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
        return uocBargainingRepository.createBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingParentDo createBargainingParent(UocBargainingParentDo uocBargainingParentDo) {
        if (null == uocBargainingParentDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.createBargainingParent(uocBargainingParentDo);
    }

    @Override
    public UocBargainingDo qryBargaining(UocBargainingDo uocBargainingDo) {
        return uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public void updateBargaining(UocBargainingDo uocBargainingDo) {
        uocBargainingRepository.updateBargaining(uocBargainingDo);
    }

    @Override
    public UocBargainingDo qryBargainingBy(UocBargainingDo uocBargainingDo) {
        if (null == uocBargainingDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryBargainingBy(uocBargainingDo);
    }

    @Override
    public List<UocBargainingItem> qryBargainingItemList(UocBargainingItemQryBo uocBargainingItemQryBo) {
        if (null == uocBargainingItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryBargainingItemList(uocBargainingItemQryBo);
    }

    @Override
    public BasePageRspBo<UocBargainingItem> getListPageBargainingItem(UocBargainingItemQryBo uocBargainingItemQryBo) {
        return uocBargainingRepository.qryListPageBargainingItem(uocBargainingItemQryBo);
    }
    /**
     * 生成议价单编号
     **/
    @Override
    public String genRequestCode(String code) {
        return uocCommonRepository.getOrderNoSingle(code);
    }

    @Override
    public List<UocQryBargainingProgressRecordBo> getList(UocQryBargainingProgressRecordReqBo reqBo) {
        return uocBargainingRepository.getList(reqBo);
    }

    @Override
    public UocBargainingAddressBo getModelBy(UocBargaining reqBo) {
        return uocBargainingRepository.getModelBy(reqBo);
    }

    @Override
    public List<UocQryQuotationBo> qryListBargainingQuotatio(UocQryQuotationListServiceReqBo reqBo) {
        return uocBargainingRepository.qryListBargainingQuotatio(reqBo);
    }

    @Override
    public UocBargainingItemPageRspBo qryBargainingItemPage(UocBargainingItemPageReqBo reqBo) {
        return uocBargainingRepository.qryBargainingItemPage(reqBo);
    }

    @Override
    public UocBargainingQuotationDo createQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        if (null == uocBargainingQuotationDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.createQuotation(uocBargainingQuotationDo);
    }

    @Override
    public void updateQuotation(UocBargainingQuotationDo uocBargainingQuotationDo) {
        if (null == uocBargainingQuotationDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocBargainingQuotationDo.getQuotationId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参报价单ID不能为空");
        }
        uocBargainingRepository.updateQuotation(uocBargainingQuotationDo);
    }

    @Override
    public void updateQuotationItemWithSkuId(UocBargainingQuotationDo uocBargainingQuotationDo) {
        uocBargainingRepository.updateQuotationItem(uocBargainingQuotationDo);
    }

    @Override
    public UocBargainingQuotationBo getQuotationBy(UocBargainingQuotationBo uocBargainingQuotationBo){
       return uocBargainingRepository.getQuotationBy(uocBargainingQuotationBo);
    }

    @Override
    public void insertProgressRecord(UocBargainingProgressRecordDo uocBargainingProgressRecordDo){
        uocBargainingRepository.insertProgressRecord(uocBargainingProgressRecordDo);
    }
}
