package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述：议价单申请服务
 *
 * @author Dum
 * @date 2023/7/29 16:37
 **/
@HTServiceImpl
@Slf4j
public class UocCreateBargainingServiceImpl implements UocCreateBargainingService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Value("${uoc.quote.Max.round.count:3}")
    private int quoteMaxRound;
    @Override
    public UocCreateBargainingRspBo createBargaining(UocCreateBargainingReqBo reqBo) {
        //主订单创建
        UocBargainingParentDo bargainingParentDo = new UocBargainingParentDo();
        bargainingParentDo.setBargainingParentId(IdUtil.nextId());
        bargainingParentDo.setCreateTime(new Date());
        bargainingParentDo.setBargainingDesc(reqBo.getRemark());
        UocBargainingParentDo uocBargainingParentDo = this.uocBargainingModel.createBargainingParent(bargainingParentDo);
        log.info("父单结果：{}", JSON.toJSONString(uocBargainingParentDo));
        //议价单-调用拆分方法
        List<UocBargainingDo> bargainingDos= splitBargainingDo(reqBo,bargainingParentDo.getBargainingParentId());
        List<UocBargainingCreateResultBo> uocBargainingList = new ArrayList<>();
        for (UocBargainingDo uocBargainingDo : bargainingDos) {
            //创建议价单
            UocBargainingDo bargainingDo = createBargaining(uocBargainingDo);
            UocBargainingCreateResultBo bargainingCreateResultBo = new UocBargainingCreateResultBo();
            bargainingCreateResultBo.setBargainingId(bargainingDo.getBargainingId());
            bargainingCreateResultBo.setBargainingNo(bargainingDo.getBargainingNo());
            bargainingCreateResultBo.setPurOrgId(bargainingDo.getPurOrgId());
            uocBargainingList.add(bargainingCreateResultBo);
            //初始化报价单
            createBargainingQuotation(bargainingDo);
        }

        UocCreateBargainingRspBo uocCreateBargainingRspBo = new UocCreateBargainingRspBo();
        uocCreateBargainingRspBo.setBargainingParentId(String.valueOf(bargainingParentDo.getBargainingParentId()));
        uocCreateBargainingRspBo.setUocBargainingList(uocBargainingList);;
        return uocCreateBargainingRspBo;
    }
    /**
     * 根据供应商拆分议价单
     * @param reqBo
     */
    private List<UocBargainingDo> splitBargainingDo(UocCreateBargainingReqBo reqBo,Long bargainingParentId) {
        List<UocBargainingDo> uocBargainingDos = new ArrayList();
        //议价单明细
        Map<String, List<UocCreateBargainingItemBo>> bargainingItemMap = reqBo.getBargainingItemBos().stream().collect(Collectors.groupingBy(UocCreateBargainingItemBo::getSupplierId));
        //议价单地址信息
        UocBargainingAddress bargainingAddress = JSONObject.parseObject(JSON.toJSONString(reqBo.getAddressBo()), UocBargainingAddress.class);
        //对象拆分
        for (UocCreateSupplierInfoBo supplierInfoBo : reqBo.getSupplierBos()) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingParentId(bargainingParentId);
            uocBargainingDo.setQuotationExpiryTime(reqBo.getQuotationExpiryTime());
            uocBargainingDo.setBargainingOperId(String.valueOf(reqBo.getUserId()));
            uocBargainingDo.setBargainingOperName(reqBo.getName());
            uocBargainingDo.setSupId(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setSupplierName(supplierInfoBo.getSupplierName());
            uocBargainingDo.setPurOrgId(String.valueOf(reqBo.getOrgId()));
            uocBargainingDo.setPurOrgName(reqBo.getOrgName());
            uocBargainingDo.setPurCompanyId(String.valueOf(reqBo.getCompanyId()));
            uocBargainingDo.setPurCompanyName(reqBo.getCompanyName());
            uocBargainingDo.setBargainingAddress(bargainingAddress);
            uocBargainingDo.setModelSettle(reqBo.getModelSettle());
            List<UocCreateBargainingItemBo> createBargainingItemBos = bargainingItemMap.get(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setBargainingItems(JSONArray.parseArray(JSON.toJSONString(createBargainingItemBos)).toJavaList(UocBargainingItem.class));
            uocBargainingDos.add(uocBargainingDo);
        }
        return uocBargainingDos;
    }
    /**
     * 报价单初始化
     * @param bargainingDo
     */
    private void createBargainingQuotation(UocBargainingDo  bargainingDo){
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
        quotationDo.setQuotationId(IdUtil.nextId());
        quotationDo.setBargainingId(bargainingDo.getBargainingId());
        quotationDo.setCreateTime(new Date());
        quotationDo.setQuotationExpiryTime(bargainingDo.getQuotationExpiryTime());
        quotationDo.setQuotationRound(bargainingDo.getQuoteCurrentRound());
        quotationDo.setTotalOriginalPrice(bargainingDo.getTotalPrice());
        quotationDo.setQuotationStatus(UocStateConstants.BARGAINING_QUOTATION_STATES.YJ_BJZ); //未报价
        quotationDo.setCreateOperId(Long.valueOf(bargainingDo.getBargainingOperId()));
        quotationDo.setCreateOperName(bargainingDo.getBargainingOperName());
        UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingId(bargainingDo.getBargainingId());
        List<UocBargainingQuotationItem> bargainingQuotationItems = new ArrayList<>();
        for (UocBargainingItem uocBargainingItem : bargainingDo.getBargainingItems()) {
            UocBargainingQuotationItem quotationItem = new UocBargainingQuotationItem();
            quotationItem.setQuotationItemId(IdUtil.nextId());
            quotationItem.setQuotationId(quotationDo.getQuotationId());
            quotationItem.setBargainingItemId(uocBargainingItem.getBargainingItemId());
            quotationItem.setSkuId(uocBargainingItem.getSkuId());
            bargainingQuotationItems.add(quotationItem);
        }
        quotationDo.setBargainingQuotationItems(bargainingQuotationItems);
        uocBargainingModel.createQuotation(quotationDo);
    }
    /**
     * 报价单校验和初始化赋值
     * @param uocBargainingDo
     */
    private UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo){
        if(ObjectUtil.isEmpty(uocBargainingDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
        //议价单
        if (ObjectUtil.isEmpty(uocBargainingDo.getBargainingId())) {
            uocBargainingDo.setBargainingId(IdUtil.nextId());
        }
        //议价编号
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingNo())){
            uocBargainingDo.setBargainingNo(uocBargainingModel.genRequestCode(UocObjNoConstants.ORDER_BARGAIN_NO));
        }
        //默认设置为报价中状态（申请失败流程服务中更新为终止报价）
        if(ObjectUtil.isEmpty(uocBargainingDo.getBargainingState())){
            uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_BJZ);
        }
        //最大议价轮次
        if(ObjectUtil.isEmpty(uocBargainingDo.getQuoteMaxRound())){
            uocBargainingDo.setQuoteMaxRound(quoteMaxRound);
        }
        //轮次
        if(ObjectUtil.isEmpty(uocBargainingDo.getQuoteCurrentRound())){
            uocBargainingDo.setQuoteCurrentRound(new Integer(1));
        }
        //明细
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        //议价前商品总金额
        BigDecimal totalPrice =new BigDecimal(0);
        for (UocBargainingItem bargainingItem : bargainingItems) {
            bargainingItem.setBargainingId(uocBargainingDo.getBargainingId());
            if (ObjectUtil.isEmpty(bargainingItem.getBargainingItemId())) {
                bargainingItem.setBargainingItemId(IdUtil.nextId());
            }
            //为空赋值
            if (null == uocBargainingDo.getCreateTime()) {
                uocBargainingDo.setCreateTime(new Date());
            }
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            //小计
            BigDecimal saleFee = bargainingItem.getSalePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setSaleFee(saleFee);
            totalPrice = saleFee.add(totalPrice);
            BigDecimal purchaseFee = bargainingItem.getPurchasePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setPurchaseFee(purchaseFee);
            totalPrice = purchaseFee.add(totalPrice);
            //冗余字段(组织机构查询使用)
            bargainingItem.setCreateTime(uocBargainingDo.getCreateTime());
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            bargainingItem.setPurCompanyId(uocBargainingDo.getPurCompanyId());
            bargainingItem.setBargainingNo(uocBargainingDo.getBargainingNo());
            bargainingItem.setPurOrgId(uocBargainingDo.getPurOrgId());
            bargainingItem.setBargainingOperName(uocBargainingDo.getBargainingOperName());
            bargainingItem.setPurOrgName(uocBargainingDo.getPurOrgName());
            bargainingItem.setSupplierName(uocBargainingDo.getSupplierName());
        }
        uocBargainingDo.setTotalPrice(totalPrice);
        //地址
        UocBargainingAddress uocBargainingAddress = uocBargainingDo.getBargainingAddress();
        uocBargainingAddress.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingAddress.setAddressId(IdUtil.nextId());
        uocBargainingDo.setAddressId(uocBargainingAddress.getAddressId());
        return this.uocBargainingModel.createBargaining(uocBargainingDo);
    }

}
