/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQuotationBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.bargaining.UocMsgHandleQuotationService;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationItemBO;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocMsgHandleQuotationRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocMsgHandleQuotationService"})
public class UocMsgHandleQuotationServiceImpl
implements UocMsgHandleQuotationService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgHandleQuotationServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"dealQuotation"})
    public UocMsgHandleQuotationRspBo dealQuotation(@RequestBody UocMsgHandleQuotationReqBo reqBo) {
        UocMsgHandleQuotationRspBo rspBo = UocRu.success(UocMsgHandleQuotationRspBo.class);
        this.validateBo(reqBo);
        UocBargainingQuotationDo uocBargainingQuotationDo = this.assembleUpdateQuotationDo(reqBo);
        log.info("\u5904\u7406\u62a5\u4ef7\u5355-\u66f4\u65b0\u62a5\u4ef7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocBargainingQuotationDo));
        this.uocBargainingModel.updateQuotationItemWithSkuId(uocBargainingQuotationDo);
        this.uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        UocBargainingDo uocBargainingDo = this.assembleUpdateBargainingDo(uocBargainingQuotationDo);
        log.info("\u5904\u7406\u62a5\u4ef7\u5355-\u66f4\u65b0\u8bae\u4ef7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocBargainingDo));
        this.uocBargainingModel.updateBargaining(uocBargainingDo);
        this.uocBargainingModel.updateBargainingItemConfirmedPrice(uocBargainingDo);
        this.insertProgressRecord(uocBargainingQuotationDo);
        rspBo.setBargainingId(uocBargainingQuotationDo.getBargainingId());
        rspBo.setTaskId(this.getTaskInstId(uocBargainingQuotationDo));
        return rspBo;
    }

    private UocBargainingQuotationDo assembleUpdateQuotationDo(UocMsgHandleQuotationReqBo reqBo) {
        UocBargainingQuotationBo qryBargainingQuotationBo = new UocBargainingQuotationBo();
        qryBargainingQuotationBo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        UocBargainingQuotationBo quotationBo = this.uocBargainingModel.getQuotationBy(qryBargainingQuotationBo);
        if (quotationBo == null) {
            throw new BaseBusinessException("100001", "\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UocBargainingQuotationDo bargainingQuotationDo = new UocBargainingQuotationDo();
        bargainingQuotationDo.setQuotationStatus("1");
        bargainingQuotationDo.setBargainingId(quotationBo.getBargainingId());
        BigDecimal totalOriginalPrice = quotationBo.getTotalOriginalPrice();
        BigDecimal totalConfirmedPrice = new BigDecimal(0);
        BigDecimal totalDiscountRate = new BigDecimal(0);
        bargainingQuotationDo.setQuotationId(Long.valueOf(reqBo.getThirdApplyId()));
        bargainingQuotationDo.setBiddingCode(reqBo.getBiddingCode());
        bargainingQuotationDo.setBiddingStatus(reqBo.getBiddingStatus());
        bargainingQuotationDo.setOrderDeadLine(reqBo.getOrderDeadLine());
        List skuItem = reqBo.getSkuInfoList();
        ArrayList<UocBargainingQuotationItem> quotationItemList = new ArrayList<UocBargainingQuotationItem>();
        bargainingQuotationDo.setBargainingQuotationItems(quotationItemList);
        for (UocMsgHandleQuotationItemBO skuBo : skuItem) {
            UocBargainingQuotationItem item = new UocBargainingQuotationItem();
            item.setQuotationId(bargainingQuotationDo.getQuotationId());
            item.setSkuId(Long.valueOf(skuBo.getThirdSkuUid()));
            item.setExtSkuId(String.valueOf(skuBo.getSkuId()));
            item.setConfirmedPrice(skuBo.getConfirmedPrice());
            item.setSkuName(skuBo.getSkuName());
            item.setSkuNum(skuBo.getSkuNum());
            item.setConfirmedBrandName(skuBo.getConfirmedBrandName());
            item.setConfirmedModel(skuBo.getConfirmedModel());
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setTaxRate(skuBo.getTaxRate());
            item.setNakedPrice(skuBo.getNakedPrice());
            item.setGreenFlag(skuBo.getGreenFlag());
            item.setGreenFlagDesc(skuBo.getGreenFlagDesc());
            item.setMicroCompanyFlag(skuBo.getMicroCompanyFlag());
            item.setMicroCompanyFlagDesc(skuBo.getMicroCompanyFlagDesc());
            BigDecimal confirmedPriceSub = skuBo.getConfirmedPrice().multiply(new BigDecimal(skuBo.getSkuNum()));
            item.setConfirmedPriceSub(confirmedPriceSub);
            totalConfirmedPrice = totalConfirmedPrice.add(confirmedPriceSub);
            quotationItemList.add(item);
        }
        BigDecimal savedPrice = totalOriginalPrice.subtract(totalConfirmedPrice);
        bargainingQuotationDo.setTotalConfirmedPrice(totalConfirmedPrice);
        bargainingQuotationDo.setSavedPrice(savedPrice);
        totalDiscountRate = totalConfirmedPrice.divide(totalOriginalPrice, 2, 4);
        bargainingQuotationDo.setTotalDiscountRate(totalDiscountRate);
        return bargainingQuotationDo;
    }

    private UocBargainingDo assembleUpdateBargainingDo(UocBargainingQuotationDo quotationDo) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingState("YJ_YBJ");
        uocBargainingDo.setTotalConfirmedPrice(quotationDo.getTotalConfirmedPrice());
        uocBargainingDo.setTotalDiscountRate(quotationDo.getTotalDiscountRate());
        uocBargainingDo.setBargainingId(quotationDo.getBargainingId());
        List<UocBargainingQuotationItem> skuItem = quotationDo.getBargainingQuotationItems();
        ArrayList<UocBargainingItem> bargainingItemList = new ArrayList<UocBargainingItem>();
        uocBargainingDo.setBargainingItems(bargainingItemList);
        for (UocBargainingQuotationItem skuBo : skuItem) {
            UocBargainingItem item = new UocBargainingItem();
            item.setSkuId(skuBo.getSkuId());
            item.setConfirmedPrice(skuBo.getConfirmedPrice());
            item.setConfirmedPriceSub(skuBo.getConfirmedPriceSub());
            bargainingItemList.add(item);
        }
        return uocBargainingDo;
    }

    private void validateBo(UocMsgHandleQuotationReqBo quotationReqBo) {
        if (quotationReqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)quotationReqBo.getThirdApplyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8bae\u4ef7\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List quotationItems = quotationReqBo.getSkuInfoList();
        if (ObjectUtil.isEmpty((Object)quotationItems)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u62a5\u4ef7\u660e\u7ec6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocMsgHandleQuotationItemBO quotationItemBO : quotationItems) {
            if (ObjectUtil.isEmpty((Object)quotationItemBO.getThirdSkuUid())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u62a5\u4ef7\u660e\u7ec6\u884c\u53f7\uff08SkuID\uff09]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)quotationItemBO.getSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u62a5\u4ef7\u660e\u7ec6\u5355\u54c1ID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)quotationItemBO.getConfirmedPrice())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u62a5\u4ef7\u660e\u7ec6-\u62a5\u4ef7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)quotationItemBO.getSkuName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)quotationItemBO.getSkuNum())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void calculateTotal(UocBargainingQuotationDo quotationDo) {
    }

    private String getTaskInstId(UocBargainingQuotationDo quotationDo) {
        String taskId = "";
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(quotationDo.getBargainingId());
        taskInstQryBo.setObjId(quotationDo.getBargainingId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        List<UocOrderTaskInst> taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isEmpty(taskInsts)) {
            throw new BaseBusinessException("101002", "\u8bae\u4ef7\u5355\u62a5\u4ef7\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u8868\u4fe1\u606f!");
        }
        taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
        log.info("\u8bae\u4ef7\u6d41\u7a0b\u6d41\u7a0b\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(taskInsts));
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            taskId = taskInsts.get(0).getTaskInstId();
        }
        return taskId;
    }

    private void insertProgressRecord(UocBargainingQuotationDo quotationDo) {
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(quotationDo.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CANCEL);
        recordDo.setOperTypeName("\u62a5\u4ef7\u5b8c\u6210");
        recordDo.setOperId(1111L);
        recordDo.setOperName("\u81ea\u52a8\u4efb\u52a1");
        recordDo.setOperTime(new Date());
        this.uocBargainingModel.insertProgressRecord(recordDo);
    }
}

