/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocEsSyncServicePro;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocEsSyncServicePro"})
public class UocEsSyncServiceProImpl
implements UocEsSyncServicePro {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncServiceProImpl.class);
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"sync"})
    public UocEsSyncRspBo sync(@RequestBody UocEsSyncReqBo reqBo) {
        this.val(reqBo);
        if (!reqBo.getAll().booleanValue()) {
            UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(reqBo, UocEsSyncManagerSaveDataReqBo.class);
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(reqBo.getOrderId());
            signleSync.setObjId(reqBo.getObjId());
            signleSync.setIndexName(reqBo.getIndexName());
            this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(signleSync));
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (this.uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
            this.batchSyncSale();
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void batchSyncSale() {
        this.iUocSaleOrderModel.batchSyncSale();
    }

    private void delAndCreateIdx(String idx) {
        block2: {
            try {
                this.uocElasticsearchUtil.deleteIndex(idx);
                this.uocElasticsearchUtil.createIndex(idx);
            }
            catch (Exception e) {
                String eCause = JSON.toJSONString((Object)e.getCause());
                log.error(eCause);
                if (!eCause.contains("index_not_found_exception")) break block2;
                log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!reqBo.getAll().booleanValue()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ID\u4e3a\u7a7a");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getIndexName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u7d22\u5f15\u540d\u4e3a\u7a7a");
            }
        }
    }
}

