package com.tydic.dyc.oc.components.thread.runnable;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.constants.UocConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocSyncEsRunnable
 * 说明:订单es同步Runnable对象
 * 时间:2023/8/26 10:14
 * 作者:田桂银
 */
@Slf4j
public class UocSyncEsRunnable implements Runnable {

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    @Override
    public void run() {
        for (SyncEsRunnableBo syncEsRunnableBo : syncEsRunnableBoList) {
            //TODO 先临时解决下同步问题
//            try {
//                Thread.sleep(2000);
//            } catch (InterruptedException e) {
//                throw new RuntimeException(e);
//            }
            try {
                Integer opFlag = syncEsRunnableBo.getOpFlag();
                if (UocConstant.ES_SYNC_OP_FLAG.SAVE.equals(opFlag)) {
                    uocEsSyncManager.saveData(convertToSyncManagerBo(syncEsRunnableBo));
                } else if (UocConstant.ES_SYNC_OP_FLAG.UPDATE.equals(opFlag)) {
                    uocEsSyncManager.updateData(convertToSyncManagerBo(syncEsRunnableBo));
                } else if (UocConstant.ES_SYNC_OP_FLAG.DELETE.equals(opFlag)) {
                    uocEsSyncManager.deleteData(convertToSyncManagerBo(syncEsRunnableBo));
                } else {
                    log.info("同步es线程：无对应操作类型【" + opFlag + "】");
                }
            } catch (Exception e) {
                log.error("Es同步数据保存参数失败：{}", e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private UocEsSyncManagerSaveDataReqBo convertToSyncManagerBo(SyncEsRunnableBo syncEsRunnableBo) {
        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        saveDataReqBo.setOrderId(syncEsRunnableBo.getOrderId());
        saveDataReqBo.setObjId(syncEsRunnableBo.getObjId());
        saveDataReqBo.setJsonObj(syncEsRunnableBo.getJsonObj());
        saveDataReqBo.setIndexName(syncEsRunnableBo.getIndexName());
        return saveDataReqBo;
    }

    private List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

    public UocSyncEsRunnable(SyncEsRunnableBo syncEsRunnableBo) {
        this.syncEsRunnableBoList.add(syncEsRunnableBo);
    }

    public UocSyncEsRunnable(List<SyncEsRunnableBo> syncEsRunnableBoList) {
        this.syncEsRunnableBoList = syncEsRunnableBoList;
    }
}


