package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.components.transactionservice.UocArrvalAcceptanceBySaleOrderTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderServiceReqBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-到货验收实现〉
 *
 * @author : yuhao
 * @date : 2022/8/26 16:44
 */
@Slf4j
@HTServiceImpl
public class UocArrvalAcceptanceBySaleOrderServiceImpl implements UocArrvalAcceptanceBySaleOrderService {

    @Autowired
    private UocArrvalAcceptanceBySaleOrderTransaction uocArrvalAcceptanceBySaleOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocArrvalAcceptanceBySaleOrderRspBo dealArrvalAcceptance(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo) {

        UocArrvalAcceptanceBySaleOrderRspBo rspBo = uocArrvalAcceptanceBySaleOrderTransaction.dealArrvalAcceptance(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocArrvalAcceptanceBySaleOrderServiceReqBo reqBo, UocArrvalAcceptanceBySaleOrderRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(saleBo);
        list.add(inspBo);
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
