package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocEsSyncServiceProImpl
 * 说明: 新数据同步，批量底层使用多线程同步
 * 时间:2023/8/26 19:26
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class UocEsSyncServiceProImpl implements UocEsSyncServicePro{
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocEsSyncRspBo sync(UocEsSyncReqBo reqBo) {
        val(reqBo);
        if (!reqBo.getAll()) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(reqBo.getOrderId());
            signleSync.setObjId(reqBo.getObjId());
            signleSync.setIndexName(reqBo.getIndexName());
            uocThreadPool.executeRunnable(new UocSyncEsRunnable(signleSync));
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
//            delAndCreateIdx(uocIndexConfig.getSaleOrderIndex());
            batchSyncSale();
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void batchSyncSale() {
        iUocSaleOrderModel.batchSyncSale();
    }


    private void delAndCreateIdx(String idx) {
        try {
            uocElasticsearchUtil.deleteIndex(idx);
            uocElasticsearchUtil.createIndex(idx);
        } catch (Exception e) {
            String eCause = JSON.toJSONString(e.getCause());
            log.error(eCause);
            if (eCause.contains(UocIndexConfig.INDEX_EXCEPTION)) {
                log.info("索引不存在");
            }
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (!reqBo.getAll()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ID为空");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
            }
            if (StringUtils.isBlank(reqBo.getIndexName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参索引名为空");
            }
        }
    }
}


