/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingParentDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingQuotationItem;
import com.tydic.dyc.oc.service.bargaining.UocCreateBargainingService;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingCreateResultBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingItemBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateBargainingRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCreateSupplierInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocCreateBargainingService"})
public class UocCreateBargainingServiceImpl
implements UocCreateBargainingService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateBargainingServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Value(value="${uoc.quote.Max.round.count:3}")
    private int quoteMaxRound;

    @PostMapping(value={"createBargaining"})
    public UocCreateBargainingRspBo createBargaining(@RequestBody UocCreateBargainingReqBo reqBo) {
        UocBargainingParentDo bargainingParentDo = new UocBargainingParentDo();
        bargainingParentDo.setBargainingParentId(IdUtil.nextId());
        bargainingParentDo.setCreateTime(new Date());
        bargainingParentDo.setBargainingDesc(reqBo.getRemark());
        UocBargainingParentDo uocBargainingParentDo = this.uocBargainingModel.createBargainingParent(bargainingParentDo);
        log.info("\u7236\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)uocBargainingParentDo));
        List<UocBargainingDo> bargainingDos = this.splitBargainingDo(reqBo, bargainingParentDo.getBargainingParentId());
        ArrayList<UocBargainingCreateResultBo> uocBargainingList = new ArrayList<UocBargainingCreateResultBo>();
        for (UocBargainingDo uocBargainingDo : bargainingDos) {
            UocBargainingDo bargainingDo = this.createBargaining(uocBargainingDo);
            UocBargainingCreateResultBo bargainingCreateResultBo = new UocBargainingCreateResultBo();
            bargainingCreateResultBo.setBargainingId(bargainingDo.getBargainingId());
            bargainingCreateResultBo.setBargainingNo(bargainingDo.getBargainingNo());
            bargainingCreateResultBo.setPurOrgId(bargainingDo.getPurOrgId());
            uocBargainingList.add(bargainingCreateResultBo);
            this.createBargainingQuotation(bargainingDo);
        }
        UocCreateBargainingRspBo uocCreateBargainingRspBo = new UocCreateBargainingRspBo();
        uocCreateBargainingRspBo.setBargainingParentId(String.valueOf(bargainingParentDo.getBargainingParentId()));
        uocCreateBargainingRspBo.setUocBargainingList(uocBargainingList);
        return uocCreateBargainingRspBo;
    }

    private List<UocBargainingDo> splitBargainingDo(UocCreateBargainingReqBo reqBo, Long bargainingParentId) {
        ArrayList<UocBargainingDo> uocBargainingDos = new ArrayList<UocBargainingDo>();
        Map<String, List<UocCreateBargainingItemBo>> bargainingItemMap = reqBo.getBargainingItemBos().stream().collect(Collectors.groupingBy(UocCreateBargainingItemBo::getSupplierId));
        UocBargainingAddress bargainingAddress = (UocBargainingAddress)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo.getAddressBo()), UocBargainingAddress.class);
        for (UocCreateSupplierInfoBo supplierInfoBo : reqBo.getSupplierBos()) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingParentId(bargainingParentId);
            uocBargainingDo.setQuotationExpiryTime(reqBo.getQuotationExpiryTime());
            uocBargainingDo.setBargainingOperId(String.valueOf(reqBo.getUserId()));
            uocBargainingDo.setBargainingOperName(reqBo.getName());
            uocBargainingDo.setSupId(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setSupplierName(supplierInfoBo.getSupplierName());
            uocBargainingDo.setPurOrgId(String.valueOf(reqBo.getOrgId()));
            uocBargainingDo.setPurOrgName(reqBo.getOrgName());
            uocBargainingDo.setPurCompanyId(String.valueOf(reqBo.getCompanyId()));
            uocBargainingDo.setPurCompanyName(reqBo.getCompanyName());
            uocBargainingDo.setBargainingAddress(bargainingAddress);
            uocBargainingDo.setModelSettle(reqBo.getModelSettle());
            List<UocCreateBargainingItemBo> createBargainingItemBos = bargainingItemMap.get(String.valueOf(supplierInfoBo.getSupplierId()));
            uocBargainingDo.setBargainingItems(JSONArray.parseArray((String)JSON.toJSONString(createBargainingItemBos)).toJavaList(UocBargainingItem.class));
            uocBargainingDos.add(uocBargainingDo);
        }
        return uocBargainingDos;
    }

    private void createBargainingQuotation(UocBargainingDo bargainingDo) {
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
        quotationDo.setQuotationId(IdUtil.nextId());
        quotationDo.setBargainingId(bargainingDo.getBargainingId());
        quotationDo.setCreateTime(new Date());
        quotationDo.setQuotationExpiryTime(bargainingDo.getQuotationExpiryTime());
        quotationDo.setQuotationRound(bargainingDo.getQuoteCurrentRound());
        quotationDo.setTotalOriginalPrice(bargainingDo.getTotalPrice());
        quotationDo.setQuotationStatus("0");
        quotationDo.setCreateOperId(Long.valueOf(bargainingDo.getBargainingOperId()));
        quotationDo.setCreateOperName(bargainingDo.getBargainingOperName());
        UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingId(bargainingDo.getBargainingId());
        ArrayList<UocBargainingQuotationItem> bargainingQuotationItems = new ArrayList<UocBargainingQuotationItem>();
        for (UocBargainingItem uocBargainingItem : bargainingDo.getBargainingItems()) {
            UocBargainingQuotationItem quotationItem = new UocBargainingQuotationItem();
            quotationItem.setQuotationItemId(IdUtil.nextId());
            quotationItem.setQuotationId(quotationDo.getQuotationId());
            quotationItem.setBargainingItemId(uocBargainingItem.getBargainingItemId());
            quotationItem.setBargainingId(uocBargainingItem.getBargainingId());
            quotationItem.setSkuId(uocBargainingItem.getSkuId());
            bargainingQuotationItems.add(quotationItem);
        }
        quotationDo.setBargainingQuotationItems(bargainingQuotationItems);
        this.uocBargainingModel.createQuotation(quotationDo);
    }

    private UocBargainingDo createBargaining(UocBargainingDo uocBargainingDo) {
        if (ObjectUtil.isEmpty((Object)uocBargainingDo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingId())) {
            uocBargainingDo.setBargainingId(IdUtil.nextId());
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingNo())) {
            uocBargainingDo.setBargainingNo(this.uocBargainingModel.genRequestCode("ORDER_BARGAIN_NO"));
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getBargainingState())) {
            uocBargainingDo.setBargainingState("YJ_BJZ");
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getQuoteMaxRound())) {
            uocBargainingDo.setQuoteMaxRound(this.quoteMaxRound);
        }
        if (ObjectUtil.isEmpty((Object)uocBargainingDo.getQuoteCurrentRound())) {
            uocBargainingDo.setQuoteCurrentRound(new Integer(1));
        }
        List<UocBargainingItem> bargainingItems = uocBargainingDo.getBargainingItems();
        BigDecimal totalPrice = new BigDecimal(0);
        for (UocBargainingItem bargainingItem : bargainingItems) {
            bargainingItem.setBargainingId(uocBargainingDo.getBargainingId());
            if (ObjectUtil.isEmpty((Object)bargainingItem.getBargainingItemId())) {
                bargainingItem.setBargainingItemId(IdUtil.nextId());
            }
            if (null == uocBargainingDo.getCreateTime()) {
                uocBargainingDo.setCreateTime(new Date());
            }
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            BigDecimal saleFee = bargainingItem.getSalePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setSaleFee(saleFee);
            totalPrice = saleFee.add(totalPrice);
            BigDecimal purchaseFee = bargainingItem.getPurchasePrice().multiply(bargainingItem.getPurchaseCount());
            bargainingItem.setPurchaseFee(purchaseFee);
            totalPrice = purchaseFee.add(totalPrice);
            bargainingItem.setCreateTime(uocBargainingDo.getCreateTime());
            bargainingItem.setBargainingOperId(uocBargainingDo.getBargainingOperId());
            bargainingItem.setSupId(uocBargainingDo.getSupId());
            bargainingItem.setPurCompanyId(uocBargainingDo.getPurCompanyId());
            bargainingItem.setBargainingNo(uocBargainingDo.getBargainingNo());
            bargainingItem.setPurOrgId(uocBargainingDo.getPurOrgId());
            bargainingItem.setBargainingOperName(uocBargainingDo.getBargainingOperName());
            bargainingItem.setPurOrgName(uocBargainingDo.getPurOrgName());
            bargainingItem.setSupplierName(uocBargainingDo.getSupplierName());
        }
        uocBargainingDo.setTotalPrice(totalPrice);
        UocBargainingAddress uocBargainingAddress = uocBargainingDo.getBargainingAddress();
        uocBargainingAddress.setBargainingId(uocBargainingDo.getBargainingId());
        uocBargainingAddress.setAddressId(IdUtil.nextId());
        uocBargainingDo.setAddressId(uocBargainingAddress.getAddressId());
        return this.uocBargainingModel.createBargaining(uocBargainingDo);
    }
}

